<?php
class SharedModel {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function saveSharedWeight($groupKey, $totalWeight, $invoiceId) {
        $sql = "INSERT INTO shared_weights (group_key, total_weight, invoice_id) VALUES (?, ?, ?)";
        return $this->db->query($sql, [$groupKey, $totalWeight, $invoiceId]);
    }
    
    public function saveSharedCartons($groupKey, $totalCartons, $invoiceId) {
        $sql = "INSERT INTO shared_cartons (group_key, total_cartons, invoice_id) VALUES (?, ?, ?)";
        return $this->db->query($sql, [$groupKey, $totalCartons, $invoiceId]);
    }
    
    public function saveSharedCBM($groupKey, $totalCBM, $invoiceId) {
        $sql = "INSERT INTO shared_cbm (group_key, total_cbm, invoice_id) VALUES (?, ?, ?)";
        return $this->db->query($sql, [$groupKey, $totalCBM, $invoiceId]);
    }
    
    public function getSharedWeightsByInvoice($invoiceId) {
        $sql = "SELECT * FROM shared_weights WHERE invoice_id = ?";
        $stmt = $this->db->query($sql, [$invoiceId]);
        return $stmt->fetchAll();
    }
    
    public function getSharedCartonsByInvoice($invoiceId) {
        $sql = "SELECT * FROM shared_cartons WHERE invoice_id = ?";
        $stmt = $this->db->query($sql, [$invoiceId]);
        return $stmt->fetchAll();
    }
    
    public function getSharedCBMByInvoice($invoiceId) {
        $sql = "SELECT * FROM shared_cbm WHERE invoice_id = ?";
        $stmt = $this->db->query($sql, [$invoiceId]);
        return $stmt->fetchAll();
    }
}
?>