<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; margin: 5px auto; max-width: 1200px;">
    <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-user-plus" style="margin-left: 8px;"></i>
                إضافة عميل جديد
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #8e44ad; padding: 4px 8px; border-radius: 0;">سجل العملاء</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #8e44ad; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري حفظ بيانات العميل...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="customerForm" onsubmit="showLoader()">
            <div style="padding: 25px;">
                <!-- معلومات العميل الأساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #8e44ad; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-id-card" style="margin-left: 8px; color: #8e44ad;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم العميل
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#8e44ad'; this.style.boxShadow='0 0 0 2px rgba(142,68,173,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>"
                                   placeholder="أدخل اسم العميل الكامل">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> الاسم الكامل للعميل أو المؤسسة
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="phone" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                رقم الهاتف
                            </label>
                            <div style="position: relative;">
                                <input type="text" class="form-control" id="phone" name="phone" 
                                       style="width: 100%; padding: 10px 12px 10px 35px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>"
                                       placeholder="مثال: 0512345678">
                                <i class="fas fa-phone" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d; font-size: 14px;"></i>
                            </div>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> رقم التواصل الرئيسي للعميل
                            </small>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="address" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                            العنوان
                        </label>
                        <textarea class="form-control" id="address" name="address" rows="3"
                                  style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; resize: vertical; min-height: 80px;"
                                  placeholder="أدعنوان العميل الكامل..."><?php echo htmlspecialchars($_POST['address'] ?? ''); ?></textarea>
                        <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                            <i class="fas fa-info-circle"></i> العنوان التفصيلي للعميل للتوصيل والفواتير
                        </small>
                    </div>
                </div>

                <!-- المعلومات المالية -->
                <div class="form-section" style="margin-bottom: 30px;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #27ae60; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-chart-line" style="margin-left: 8px; color: #27ae60;"></i>
                            المعلومات المالية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr; gap: 20px; max-width: 400px;">
                        <div class="form-group">
                            <label class="form-label" for="opening_balance" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الرصيد الافتتاحي
                            </label>
                            <div style="position: relative;">
                                <input type="number" step="0.01" class="form-control" id="opening_balance" name="opening_balance" 
                                       style="width: 100%; padding: 10px 12px 10px 30px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($_POST['opening_balance'] ?? '0'); ?>">
                                <span style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d;">¥</span>
                            </div>
                            <div style="background: #f8f9fa; padding: 10px; margin-top: 10px; border-left: 3px solid #3498db;">
                                <div style="display: flex; align-items: center; margin-bottom: 5px;">
                                    <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                                    <span style="font-size: 13px; color: #2c3e50;">معلومات الرصيد الافتتاحي:</span>
                                </div>
                                <ul style="margin: 0; padding-right: 15px; font-size: 12px; color: #7f8c8d;">
                                    <li>يُسجل كحركة مدينة في حساب العميل</li>
                                    <li>القيمة الموجبة تعني دين على العميل</li>
                                    <li>القيمة السالبة تعني رصيد للعميل</li>
                                    <li>اترك القيمة صفر إذا لم يكن هناك رصيد افتتاحي</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="customers.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        حفظ العميل
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
    
    /* Tooltip style for information */
    .info-tooltip {
        position: relative;
        display: inline-block;
        margin-right: 5px;
    }
    
    .info-tooltip .tooltip-text {
        visibility: hidden;
        width: 200px;
        background-color: #2c3e50;
        color: white;
        text-align: center;
        padding: 8px;
        border-radius: 0;
        position: absolute;
        z-index: 1;
        bottom: 125%;
        right: 0;
        font-size: 12px;
        opacity: 0;
        transition: opacity 0.3s;
    }
    
    .info-tooltip:hover .tooltip-text {
        visibility: visible;
        opacity: 1;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const phoneField = document.getElementById('phone');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    phoneField.style.borderColor = '#bdc3c7';
    phoneField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate phone format (optional but if provided, check format)
    if (phoneField.value.trim() && !/^[\d\s\-\+\(\)]{8,}$/.test(phoneField.value)) {
        phoneField.style.borderColor = '#e74c3c';
        phoneField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('يرجى إدخال رقم هاتف صحيح');
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Format phone number as user types
document.getElementById('phone').addEventListener('input', function(e) {
    // السماح بالأرقام فقط (0-9) وبعض الرموز مثل + - ()
    e.target.value = e.target.value.replace(/[^\d+\-() ]/g, '');
});


// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Handle form submission with AJAX (optional enhancement)
document.getElementById('customerForm').addEventListener('submit', function(e) {
    // If you want to use AJAX instead of traditional form submission:
    /*
    e.preventDefault();
    if (!validateForm()) return;
    
    showLoader();
    
    const formData = new FormData(this);
    
    fetch(this.action, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        hideLoader();
        if (data.success) {
            window.location.href = 'customers.php';
        } else {
            alert(data.error || 'حدث خطأ أثناء الحفظ');
        }
    })
    .catch(error => {
        hideLoader();
        alert('حدث خطأ في الاتصال');
    });
    */
});

function hideLoader() {
    document.getElementById('loadingOverlay').style.display = 'none';
}

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader.style.display === 'flex') {
        loader.querySelector('div:nth-child(2)').textContent = 'لا يزال جاري المعالجة...';
        loader.querySelector('div:nth-child(3)').textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>