<?php
// print_statement.php - صفحة طباعة كشف الحساب
session_start();

// --- إعدادات الاتصال بقاعدة البيانات ---
$DB_HOST = '127.0.0.1';
$DB_USER = 'root';
$DB_PASS = ']]12ISzBaO8gBGB_';
$DB_NAME = 'lastship';

$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_errno) {
    die("فشل الاتصال بقاعدة البيانات: " . $mysqli->connect_error);
}
$mysqli->set_charset('utf8mb4');

// --- تعريف أنواع الحسابات المتاحة ---
$account_types = [
    'customer' => ['name' => 'عميل', 'table' => 'customers', 'balance_field' => 'current_balance'],
    'company' => ['name' => 'شركة', 'table' => 'companies', 'balance_field' => 'current_balance'],
    'cash' => ['name' => 'صندوق', 'table' => 'cash_boxes', 'balance_field' => 'current_balance'],
    'bank' => ['name' => 'بنك', 'table' => 'bank_accounts', 'balance_field' => 'current_balance']
];

// --- معالجة المعلمات ---
$type = $_GET['type'] ?? 'customer';
$id = intval($_GET['id'] ?? 0);
$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? date('Y-m-d');
$currency_id = $_GET['currency_id'] ?? null;

// التحقق من صحة نوع الحساب
if (!isset($account_types[$type])) {
    $type = 'customer';
}

// --- جلب العملات النشطة ---
function get_currencies($mysqli) {
    $query = "SELECT id, name, code, exchange_rate, is_default FROM currencies WHERE is_active = 1 ORDER BY is_default DESC, name";
    $result = $mysqli->query($query);
    
    $currencies = [];
    while ($row = $result->fetch_assoc()) {
        $currencies[] = $row;
    }
    
    return $currencies;
}

// --- جلب العملة الافتراضية ---
function get_default_currency($mysqli) {
    $query = "SELECT id, code, name, exchange_rate FROM currencies WHERE is_default = 1";
    $result = $mysqli->query($query);
    return $result->fetch_assoc();
}

// --- جلب سعر صرف الفاتورة ---
function get_invoice_exchange_rate($mysqli, $invoice_id, $currency_id) {
    $stmt = $mysqli->prepare("
        SELECT exchange_rate 
        FROM invoice_exchange_rates 
        WHERE invoice_id = ? AND currency_id = ?
    ");
    $stmt->bind_param('ii', $invoice_id, $currency_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return $result ? $result['exchange_rate'] : null;
}

// --- جلب سعر صرف السند ---
function get_voucher_exchange_rate($mysqli, $voucher_id, $currency_id) {
    $stmt = $mysqli->prepare("
        SELECT exchange_rate 
        FROM voucher_exchange_rates 
        WHERE voucher_id = ? AND currency_id = ?
    ");
    $stmt->bind_param('ii', $voucher_id, $currency_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return $result ? $result['exchange_rate'] : null;
}

// --- جلب بيانات الكشف ---
function get_statement_data($mysqli, $type, $id, $from, $to, $currency_id = null) {
    global $account_types;
    
    // جلب العملات النشطة والعملة الافتراضية
    $currencies = get_currencies($mysqli);
    $default_currency = get_default_currency($mysqli);
    
    // تحديد العملة للعرض
    $selected_currency = null;
    $selected_currency_code = $default_currency['code'];
    $selected_currency_name = $default_currency['name'];
    $exchange_rate = 1;
    
    if ($currency_id) {
        foreach ($currencies as $currency) {
            if ($currency['id'] == $currency_id) {
                $selected_currency = $currency;
                $selected_currency_code = $currency['code'];
                $selected_currency_name = $currency['name'];
                $exchange_rate = $currency['exchange_rate'];
                break;
            }
        }
    }
    
    // جلب بيانات الكيان
    $table = $account_types[$type]['table'];
    $stmt = $mysqli->prepare("SELECT id, name FROM $table WHERE id = ?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $entity = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if (!$entity) {
        return null;
    }
    
    // حساب الرصيد الافتتاحي (بالعملة المحلية)
  
$opening_stmt = $mysqli->prepare("
    SELECT IFNULL(SUM(t.debit_amount - t.credit_amount),0) AS opening_balance
    FROM transactions t
    LEFT JOIN invoices i 
        ON t.related_invoice_id = i.id
    WHERE t.account_type = ?
      AND t.account_id = ?
      AND t.is_reversed = 0
      AND DATE(t.date) < ?
      AND (
            t.related_invoice_id IS NULL
            OR i.status = 'confirmed'
          )
");
$opening_stmt->bind_param('sis', $type, $id, $from);
$opening_stmt->execute();
$opening_res = $opening_stmt->get_result()->fetch_assoc();
$opening_balance_local = (float)$opening_res['opening_balance'];
$opening_stmt->close();

    
    // تحويل الرصيد الافتتاحي إلى العملة المختارة
    $opening_balance = $opening_balance_local * $exchange_rate;
    
    // جلب الحركات خلال الفترة
  
$tx_stmt = $mysqli->prepare("
    SELECT 
        t.id,
        t.date,
        t.description,
        t.debit_amount,
        t.credit_amount,
        t.voucher_type,
        t.related_voucher_id,
        t.related_invoice_id,
        t.created_at,
        t.cash_box_id,
        t.bank_account_id
    FROM transactions t
    LEFT JOIN invoices i 
        ON t.related_invoice_id = i.id
    WHERE t.account_type = ?
      AND t.account_id = ?
      AND t.is_reversed = 0
      AND DATE(t.date) BETWEEN ? AND ?
      AND (
            t.related_invoice_id IS NULL
            OR i.status = 'confirmed'
          )
    ORDER BY t.date ASC, t.id ASC
");
$tx_stmt->bind_param('siss', $type, $id, $from, $to);
$tx_stmt->execute();
$tx_result = $tx_stmt->get_result();
    
    // حساب الرصيد التراكمي
    $running_local = $opening_balance_local;
    $running = $opening_balance;
    $transactions = [];
    $total_debit_local = 0;
    $total_credit_local = 0;
    $total_debit = 0;
    $total_credit = 0;
    
    while($row = $tx_result->fetch_assoc()) {
        $debit_local = (float)$row['debit_amount'];
        $credit_local = (float)$row['credit_amount'];
        
        $running_local += ($debit_local - $credit_local);
        
        // تحديد سعر الصرف المناسب لكل حركة
        $tx_exchange_rate = $exchange_rate;
        
        // إذا كانت الحركة مرتبطة بفاتورة
        if ($row['related_invoice_id']) {
            $invoice_rate = get_invoice_exchange_rate($mysqli, $row['related_invoice_id'], $currency_id ?: $default_currency['id']);
            if ($invoice_rate !== null) {
                $tx_exchange_rate = $invoice_rate;
            }
        }
        // إذا كانت الحركة مرتبطة بسند
        elseif ($row['related_voucher_id']) {
            $voucher_rate = get_voucher_exchange_rate($mysqli, $row['related_voucher_id'], $currency_id ?: $default_currency['id']);
            if ($voucher_rate !== null) {
                $tx_exchange_rate = $voucher_rate;
            }
        }
        
        // تحويل المبالغ إلى العملة المختارة
        $debit = $debit_local * $tx_exchange_rate;
        $credit = $credit_local * $tx_exchange_rate;
        $running = $running_local * $exchange_rate;
        
        $row['debit_amount_local'] = $debit_local;
        $row['credit_amount_local'] = $credit_local;
        $row['debit_amount_foreign'] = $debit;
        $row['credit_amount_foreign'] = $credit;
        $row['exchange_rate'] = $tx_exchange_rate;
        $row['running_balance_local'] = $running_local;
        $row['running_balance'] = $running;
        $row['formatted_date'] = date('d/m/Y', strtotime($row['date']));
        $transactions[] = $row;
        
        $total_debit_local += $debit_local;
        $total_credit_local += $credit_local;
        $total_debit += $debit;
        $total_credit += $credit;
    }
    
    $final_balance_local = $running_local;
    $final_balance = $running;
    
    return [
        'entity' => $entity,
        'account_type' => $account_types[$type],
        'from' => $from,
        'to' => $to,
        'currency' => [
            'selected' => $selected_currency,
            'selected_code' => $selected_currency_code,
            'selected_name' => $selected_currency_name,
            'exchange_rate' => $exchange_rate,
            'default' => $default_currency
        ],
        'opening_balance_local' => $opening_balance_local,
        'opening_balance' => $opening_balance,
        'transactions' => $transactions,
        'total_debit_local' => $total_debit_local,
        'total_credit_local' => $total_credit_local,
        'total_debit' => $total_debit,
        'total_credit' => $total_credit,
        'final_balance_local' => $final_balance_local,
        'final_balance' => $final_balance
    ];
}

// --- دالة تنسيق العملة ---
function format_currency($amount, $symbol) {
    return number_format($amount, 2) . ' ' . htmlspecialchars($symbol);
}

// --- جلب بيانات الكشف ---
$statement_data = get_statement_data($mysqli, $type, $id, $from, $to, $currency_id);

if (!$statement_data) {
    die('<div style="text-align:center; padding:50px; font-family:Arial;">لم يتم العثور على بيانات الكشف</div>');
}

// استخراج البيانات
extract($statement_data);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف حساب - شركة GTS</title>
      <link rel="stylesheet" href="fontawesome-free-6.7.2-web/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <style>
    body {
        font-family: 'Times New Roman', serif;
        background-color: #f8f9fa;
    }

    .invoice-container {
        max-width: 850px;
        margin: 0 auto;
        background: white;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }

    .company-info {
        text-align: center;
        margin-bottom: 5px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 10px;
    }

    .customer-info {
        background-color: #f8f9fa;
        padding: 5px;
        border-radius: 10px;
        margin-bottom: 10px;
        font-size: 12px;
        font-weight: bold;
    }

    .table th, .table td {
        border: 1px solid #d3d3d3 !important;
    }

    .table thead th {
        padding: 4px 6px !important;
        font-size: 12px;
    }

    .table tbody tr {
        border: 1px solid #d3d3d3 !important;
    }

    .table thead th:nth-child(odd) {
        background-color: #eaa033 !important;
        color: white !important;
    }
    
    .table thead th:nth-child(even) {
        background-color: #22445d !important;
        color: white !important;
    }

    .summary-section {
        background-color: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-top: 20px;
    }

    .invoice-footer {
        background-color: #f8f9fa;
        padding: 20px;
        text-align: center;
        border-top: 1px solid #dee2e6;
        font-size: 12px;
    }

    @media print {
        .no-print {
            display: none !important;
        }
        
        @page {
            margin-top: 1px;
            margin-bottom: 5px;
            margin-left: 0 !important;
            margin-right: 0 !important;
            padding: 0px !important;
        }
        
        thead, tfoot {
            display: table-row-group !important;
        }
        
        tr, td, th {
            page-break-inside: auto !important;
        }
        
        table {
            page-break-inside: auto !important;
        }
        
        body {
            background-color: white;
            margin-top: 1px;
            margin-bottom: 5px;
            margin-left: 0 !important;
            margin-right: 0 !important;
            padding: 3px !important;
                 -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
        }
        
        .invoice-container {
            box-shadow: none;
        }
    }
    
    .no-print {
        text-align: center;
        margin-bottom: 10px;
    }

    .no-print button {
        color: white;
        border: none;
        padding: 10px 13px;
        border-radius: 8px;
        font-size: 18px;
        margin: 4px;
        cursor: pointer;
        transition: all 0.25s ease-in-out;
    }

    .no-print button.print-btn { background: #34416E; }
    .no-print button.whatsapp-btn { background: #25D366; }
    .no-print button.close-btn { background: #dc3545; }
    .no-print button.pdf-btn { background: #e74c3c; }

    .no-print button.print-btn:hover { background: #465493; transform: scale(1.1); }
    .no-print button.whatsapp-btn:hover { background: #2fe97a; transform: scale(1.1); }
    .no-print button.close-btn:hover { background: #e64a59; transform: scale(1.1); }
    .no-print button.pdf-btn:hover { background: #c0392b; transform: scale(1.1); }

    .no-print button:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .watermark {
        position: absolute;
        top: 450px;
        left: 50%;
        transform: translateX(-50%);
        width: 550px;
        height: 350px;
        background-image: url('logo_water.png');
        background-size: contain;
        background-repeat: no-repeat;
        opacity: 0.07;
        z-index: 0;
        pointer-events: none;
    }

    .total-row {
        font-weight: bold;
        background-color: #f0f0f0 !important;
    }

    .positive {
        color: #27ae60;
    }

    .negative {
        color: #e74c3c;
    }

    .signature-section {
        margin-top: 40px;
        padding-top: 20px;
        border-top: 2px dashed #333;
    }

    .signature-box {
        display: inline-block;
        width: 200px;
        text-align: center;
        margin: 0 20px;
    }

    .signature-line {
        width: 150px;
        height: 1px;
        border-bottom: 1px solid #000;
        margin: 20px auto;
    }

    .currency-badge {
        display: inline-block;
        background: #17a2b8;
        color: white;
        padding: 2px 6px;
        border-radius: 3px;
        font-size: 10px;
        margin-right: 3px;
    }
    </style>
</head>
<body>
    <div class="container-fluid py-4" id="statement-container">
        <div class="invoice-container">
            <!-- Header -->
            <div class="company-info" style="padding:0; margin-bottom:10px; background:none; text-align:center;">
               <img src="logo2.png" alt="Company Logo" style="width:50%; height:50%; display:block; margin:0 auto;">


                <div style="text-align:center; margin-top:12px; font-size:12px; direction:ltr;">
                    <p style="margin-bottom:2px;">
                        <img src="phone.png" alt="contact" style="height:50px;">
                    </p>
                </div>

                <div style="height:2px; width:80%; background:#22445d; margin:3px 0 3px 20px; float:left;"></div>
                <div style="clear:both;"></div>
            </div>

            <!-- Body -->
            <div class="invoice-body" style="padding:16px; position:relative;">
                <!-- Watermark -->
                <div class="watermark"></div>

                <!-- Statement Info -->
                <div class="customer-info" style="padding:6px; border-radius:4px; margin:-16px 0 10px 0;">
                    <div style="display:flex; justify-content:space-between; margin-bottom:4px;">
                        <span style="background:#eaa033; padding:1px 10px; color:#fff;">
                            كشف حساب رقم: <?= $id ?>
                        </span>
                        <span style="background:#eaa033; padding:1px 10px; color:#fff;">
                            <?= htmlspecialchars($account_type['name']) ?>: <?= htmlspecialchars($entity['name']) ?>
                        </span>
                    </div>

                    <div style="display:flex; justify-content:space-between;">
                        <div style="display:flex; flex-direction:column; gap:2px;">
                            <span>من تاريخ: <?= date('d/m/Y', strtotime($from)) ?></span>
                            <span>إلى تاريخ: <?= date('d/m/Y', strtotime($to)) ?></span>
                        </div>
                        <div style="display:flex; flex-direction:column; gap:2px; text-align:left;">
                            <span>تاريخ الطباعة: <?= date('Y-m-d H:i') ?></span>
                            <span>العملة: <?= htmlspecialchars($currency['selected_name']) ?> (<?= htmlspecialchars($currency['selected_code']) ?>)</span>
                        </div>
                    </div>
                </div>

                <!-- Exchange Rate Info -->

                <!-- Summary Cards -->
                <div class="row mb-3" style="direction: rtl;">
                    <div class="col-md-3 col-6">
                        <div style="background:#f8f9fa; padding:2px; border-radius:5px; text-align:center; border:1px solid #dee2e6;">
                            <div style="font-size:11px; color:#666;">الرصيد السابق</div>
                            <div style="font-size:16px; font-weight:bold; <?= $opening_balance >= 0 ? 'color:#27ae60' : 'color:#e74c3c' ?>">
                                <?= format_currency($opening_balance, $currency['selected_code']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div style="background:#f8f9fa; padding:2px; border-radius:5px; text-align:center; border:1px solid #dee2e6;">
                            <div style="font-size:11px; color:#666;">إجمالي المدين ’’عليه‘‘</div>
                            <div style="font-size:16px; font-weight:bold; color:#27ae60">
                                <?= format_currency($total_debit, $currency['selected_code']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div style="background:#f8f9fa; padding:2px; border-radius:5px; text-align:center;margin-top:5px ; border:1px solid #dee2e6;">
                            <div style="font-size:11px; color:#666;">إجمالي الدائن’’له‘‘</div>
                            <div style="font-size:16px; font-weight:bold; color:#e74c3c">
                                <?= format_currency($total_credit, $currency['selected_code']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div style="background:#f8f9fa; padding:2px; border-radius:5px; text-align:center;margin-top:5px ; border:1px solid #dee2e6;">
                            <div style="font-size:11px; color:#666;">الرصيد النهائي</div>
                            <div style="font-size:16px; font-weight:bold; <?= $final_balance >= 0 ? 'color:#27ae60' : 'color:#e74c3c' ?>">
                                <?= format_currency($final_balance, $currency['selected_code']) ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transactions Table -->
                <div class="table-responsive">
                   <table class="table table-bordered" style="direction: rtl;">
    <colgroup>
        <col style="width: 3%;">
        <col style="width: 8%;">
        <col style="width: 25%;">
        <col style="width: 10%;">
        <col style="width: 10%;">
        <col style="width: 10%;">
        <col style="width: 8%;">
        <?php if ($currency['selected']): ?>
        <col style="width: 8%;">
        <?php endif; ?>
    </colgroup>

    <thead>
        <tr>
            <th style="color:black; font-size:12px; text-align:center;">#</th>
            <th style="color:black; font-size:12px; text-align:center;">التاريخ</th>
            <th style="color:black; font-size:12px; text-align:center;">البيان</th>
            <th style="background:yellow; color:black; font-size:12px; text-align:center;">مدين ’’عليه ‘‘</th>
            <th style="background:yellow; color:black; font-size:12px; text-align:center;">دائن ’’ له‘‘</th>
            <th style="color:black; font-size:12px; text-align:center;">الرصيد</th>
            <th style="color:black; font-size:12px; text-align:center;">الحالة</th>
            <?php if ($currency['selected']): ?>
            <th style="color:black; font-size:12px; text-align:center;">سعر الصرف</th>
            <?php endif; ?>
        </tr>
    </thead>

    <tbody>
        <!-- Opening Balance Row -->
        <tr style="background:#f0f8ff;">
            <td style="text-align:center; font-size:11px">-</td>
            <td style="text-align:center; font-size:11px"><?= date('d/m/Y', strtotime($from)) ?></td>
            <td style="text-align:right; font-weight:bold; font-size:11px">الرصيد السابق</td>
            <td style="text-align:center; font-size:11px">-</td>
            <td style="text-align:center; font-size:11px">-</td>
            <td style="text-align:center; font-weight:bold; font-size:11px; <?= $opening_balance >= 0 ? 'color:#27ae60' : 'color:#e74c3c' ?>">
                <?= format_currency($opening_balance, $currency['selected_code']) ?>
            </td>
            <td style="text-align:center; font-size:11px">افتتاحي</td>
            <?php if ($currency['selected']): ?>
            <td style="text-align:center; font-size:10px">
                <?= number_format($currency['exchange_rate'], 6) ?>
            </td>
            <?php endif; ?>
        </tr>

        <?php if (count($transactions) > 0): ?>
            <?php $counter = 1; ?>
            <?php foreach ($transactions as $tx): ?>
                <tr>
                    <td style="text-align:center; font-size:11px"><?= $counter++ ?></td>
                    <td style="text-align:center; font-size:11px"><?= $tx['formatted_date'] ?></td>
                    <td style="text-align:right; font-size:11px"><?= htmlspecialchars($tx['description']) ?></td>
                    <td style="text-align:center; color:#27ae60; font-weight:bold; font-size:11px;">
                        <?= ($tx['debit_amount_foreign'] > 0) ? format_currency($tx['debit_amount_foreign'], $currency['selected_code']) : '' ?>
                    </td>
                    <td style="text-align:center; color:#e74c3c; font-weight:bold; font-size:11px;">
                        <?= ($tx['credit_amount_foreign'] > 0) ? format_currency($tx['credit_amount_foreign'], $currency['selected_code']) : '' ?>
                    </td>
                    <td style="text-align:center; font-weight:bold; font-size:11px; <?= $tx['running_balance'] >= 0 ? 'color:#27ae60' : 'color:#e74c3c' ?>">
                        <?= format_currency($tx['running_balance'], $currency['selected_code']) ?>
                    </td>
                    <td style="text-align:center; font-size:10px;">
                        <?php if ($tx['related_invoice_id']): ?>
                            فاتورة
                        <?php elseif ($tx['related_voucher_id']): ?>
                            سند
                        <?php else: ?>
                            حركة
                        <?php endif; ?>
                    </td>
                    <?php if ($currency['selected']): ?>
                    <td style="text-align:center; font-size:10px; color:#666;">
                        <?= number_format($tx['exchange_rate'], 6) ?>
                    </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="<?= $currency['selected'] ? '8' : '7' ?>" style="text-align:center; padding:20px; color:#666; font-size:12px;">
                    لا توجد حركات في هذه الفترة
                </td>
            </tr>
        <?php endif; ?>

        <!-- Final Balance Row -->
        <tr style="background:#f0f8ff; font-weight:bold;">
            <td colspan="3" style="text-align:center; font-size:12px;">الإجمالي</td>
            <td style="text-align:center; color:#27ae60; font-size:12px;">
                <?= format_currency($total_debit, $currency['selected_code']) ?>
            </td>
            <td style="text-align:center; color:#e74c3c; font-size:12px;">
                <?= format_currency($total_credit, $currency['selected_code']) ?>
            </td>
            <td style="text-align:center; font-size:12px; <?= $final_balance >= 0 ? 'color:#27ae60' : 'color:#e74c3c' ?>">
                <?= format_currency($final_balance, $currency['selected_code']) ?>
            </td>
            <td style="text-align:center; font-size:12px;">نهائي</td>
            <?php if ($currency['selected']): ?>
            <td style="text-align:center; font-size:12px;">-</td>
            <?php endif; ?>
        </tr>
    </tbody>
</table>

                </div>

                <!-- Notes Section -->
                <div style="margin-top:5px; padding:15px; background:#fff3cd; border:1px solid #ffeaa7; border-radius:5px; direction:rtl;">
                    <h6 style="font-weight:bold; color:#856404; margin-bottom:10px; font-size:13px;">ملاحظات هامة:</h6>
                    <ul style="margin:0; padding-right:20px; font-size:11px;">
                        <li>جميع المبالغ معروضة بالعملة <?= $currency['selected'] ? htmlspecialchars($currency['selected_name']) : htmlspecialchars($currency['default']['name']) ?></li>
                        <?php if ($currency['selected']): ?>
                            <li>الرصيد الافتتاحي والرصيد التراكمي تم تحويلهما باستخدام سعر الصرف الرئيسي</li>
                            <li>الحركات المرتبطة بفواتير تم تحويلها باستخدام أسعار الصرف التاريخية المسجلة</li>
                            <li>الحركات المرتبطة بسندات تم تحويلها باستخدام أسعار الصرف التاريخية المسجلة</li>
                        <?php endif; ?>
                        <li>هذا الكشف معتمد من نظام إدارة الحسابات الإلكتروني لشركة GTS</li>
                        <li>للإستفسار يرجى الاتصال على الأرقام الموضحة في الأعلى</li>
                    </ul>
                </div>

                <!-- Signatures Section -->
                <div class="signature-section">
                    <div style="text-align:center;">
                        <div class="signature-box">
                            <div style="margin-bottom:10px;">توقيع المحاسب</div>
                            <div class="signature-line"></div>
                            <div style="font-size:10px; color:#666; margin-top:5px;">الاسم: __________________</div>
                        </div>
                        <div class="signature-box">
                            <div style="margin-bottom:10px;">توقيع المدير</div>
                            <div class="signature-line"></div>
                            <div style="font-size:10px; color:#666; margin-top:5px;">الاسم: __________________</div>
                        </div>
                        <div class="signature-box">
                            <div style="margin-bottom:10px;">توقيع <?= htmlspecialchars($account_type['name']) ?></div>
                            <div class="signature-line"></div>
                            <div style="font-size:10px; color:#666; margin-top:5px;">الاسم: __________________</div>
                        </div>
                    </div>
                </div>

              
            </div>
        </div>
        
        <!-- Buttons -->
        <div class="no-print text-center mt-3">
            <button class="print-btn" onclick="window.print()" title="طباعة">
                <i class="fa-solid fa-print"></i>
            </button>

            <button class="whatsapp-btn" onclick="shareAsPDF()" title="مشاركة عبر واتساب">
                <i class="fa-brands fa-whatsapp"></i>
            </button>

            <button class="pdf-btn" onclick="saveAsPDF()" title="حفظ كـ PDF">
                <i class="fa-solid fa-file-pdf"></i>
            </button>

            <button class="close-btn" onclick="window.close()" title="إغلاق">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
    </div>
    
    <script>
        // دالة لحفظ التقرير كـ PDF
        async function saveAsPDF() {
            const buttons = document.querySelectorAll('.no-print');
            buttons.forEach(btn => btn.style.display = 'none');

            const { jsPDF } = window.jspdf;
            const statementElement = document.getElementById('statement-container');

            if (!statementElement) {
                alert("❌ لم يتم العثور على عنصر الكشف");
                buttons.forEach(btn => btn.style.display = 'block');
                return;
            }

            try {
                const canvas = await html2canvas(statementElement, {
                    scale: 2,
                    useCORS: true,
                    backgroundColor: '#ffffff'
                });

                const imgData = canvas.toDataURL('image/jpeg', 0.9);
                const pdf = new jsPDF('p', 'mm', 'letter');

                const pageWidth = pdf.internal.pageSize.getWidth();
                const pageHeight = pdf.internal.pageSize.getHeight();
                const imgWidth = pageWidth;
                const imgHeight = (canvas.height * imgWidth) / canvas.width;

                let heightLeft = imgHeight;
                let position = 0;

                while (heightLeft > 0) {
                    pdf.addImage(imgData, 'JPEG', 0, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                    if (heightLeft > 0) {
                        pdf.addPage();
                        position = 0;
                    }
                }

                const fileName = "كشف_حساب_<?= $entity['name'] ?>_<?= date('Y-m-d') ?>.pdf";
                pdf.save(fileName);
                alert("✅ تم حفظ ملف PDF بنجاح");

            } catch (error) {
                console.error(error);
                alert("❌ حدث خطأ أثناء إنشاء الملف:\n" + error.message);
            } finally {
                buttons.forEach(btn => btn.style.display = 'block');
            }
        }

        // دالة للمشاركة عبر واتساب
        async function shareAsPDF() {
            const buttons = document.querySelectorAll('.no-print');
            buttons.forEach(btn => btn.style.display = 'none');

            const { jsPDF } = window.jspdf;
            const statementElement = document.getElementById('statement-container');

            if (!statementElement) {
                alert("❌ لم يتم العثور على عنصر الكشف");
                buttons.forEach(btn => btn.style.display = 'block');
                return;
            }

            try {
                const canvas = await html2canvas(statementElement, {
                    scale: 2,
                    useCORS: true,
                    backgroundColor: '#ffffff'
                });

                const imgData = canvas.toDataURL('image/jpeg', 0.9);
                const pdf = new jsPDF('p', 'mm', 'letter');

                const pageWidth = pdf.internal.pageSize.getWidth();
                const pageHeight = pdf.internal.pageSize.getHeight();
                const imgWidth = pageWidth;
                const imgHeight = (canvas.height * imgWidth) / canvas.width;

                let heightLeft = imgHeight;
                let position = 0;

                while (heightLeft > 0) {
                    pdf.addImage(imgData, 'JPEG', 0, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                    if (heightLeft > 0) {
                        pdf.addPage();
                        position = 0;
                    }
                }

                const pdfBlob = pdf.output('blob');
                const pdfFile = new File([pdfBlob], "كشف_حساب_<?= $entity['name'] ?>.pdf", { type: "application/pdf" });

                if (navigator.canShare && navigator.canShare({ files: [pdfFile] })) {
                    await navigator.share({
                        title: "كشف حساب - <?= $entity['name'] ?>",
                        text: "مرفق كشف حساب <?= $entity['name'] ?> من شركة GTS",
                        files: [pdfFile]
                    });
                } else {
                    pdf.save("كشف_حساب_<?= $entity['name'] ?>.pdf");
                    alert("✅ تم حفظ ملف PDF بنجاح");
                }

            } catch (error) {
                console.error(error);
                alert("❌ حدث خطأ أثناء إنشاء الملف:\n" + error.message);
            } finally {
                buttons.forEach(btn => btn.style.display = 'block');
            }
        }

        // الطباعة التلقائية عند تحميل الصفحة (اختياري)
        window.onload = function() {
            // يمكن تفعيل الطباعة التلقائية إذا أردت
            // window.print();
        };
    </script>
    
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/YOUR_KIT_CODE.js" crossorigin="anonymous"></script>
    <!-- استبدل YOUR_KIT_CODE بكودك الخاص من Font Awesome -->
    
</body>
</html>

<?php
$mysqli->close();
?>