<?php
session_start();
require_once 'reports_vouchers/db.php';
header('Content-Type: application/json');

try {
    $pdo->beginTransaction();
    
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'get_company':
            $id = intval($_POST['id']);
            $stmt = $pdo->prepare("SELECT * FROM companies WHERE id = ?");
            $stmt->execute([$id]);
            $company = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($company) {
                echo json_encode(['success' => true, 'data' => $company]);
            } else {
                echo json_encode(['success' => false, 'message' => 'الشركة غير موجودة']);
            }
            break;
            
        case 'save_company':
            $id = intval($_POST['companyId'] ?? 0);
            $name = trim($_POST['name']);
            $phone = trim($_POST['phone'] ?? '');
            $address = trim($_POST['address'] ?? '');
            $opening_balance = floatval($_POST['opening_balance']);
            $is_active = intval($_POST['is_active'] ?? 1);
            
            if (empty($name)) {
                throw new Exception('اسم الشركة مطلوب');
            }
            
            if ($id > 0) {
                // Update existing company
                $stmt = $pdo->prepare("SELECT opening_balance, current_balance FROM companies WHERE id = ?");
                $stmt->execute([$id]);
                $oldData = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // Calculate difference in opening balance
                $balance_diff = $opening_balance - $oldData['opening_balance'];
                
                // Update company
                $stmt = $pdo->prepare("UPDATE companies SET name = ?, phone = ?, address = ?, 
                                      opening_balance = ?, current_balance = current_balance + ?, 
                                      is_active = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$name, $phone, $address, $opening_balance, $balance_diff, $is_active, $id]);
                
                // Update opening balance transaction
                $stmt = $pdo->prepare("UPDATE transactions SET 
                                      debit_amount = CASE WHEN ? >= 0 THEN ? ELSE 0 END,
                                      credit_amount = CASE WHEN ? < 0 THEN ABS(?) ELSE 0 END,
                                      balance_after = ?,
                                      updated_at = NOW()
                                      WHERE account_type = 'company' AND account_id = ? 
                                      AND voucher_type IS NULL");
                $debit = $opening_balance >= 0 ? $opening_balance : 0;
                $credit = $opening_balance < 0 ? abs($opening_balance) : 0;
                $stmt->execute([$opening_balance, $debit, $opening_balance, $opening_balance, $opening_balance, $id]);
                
                echo json_encode(['success' => true, 'message' => 'تم تحديث بيانات الشركة بنجاح']);
            } else {
                // Insert new company
                $stmt = $pdo->prepare("INSERT INTO companies (name, phone, address, opening_balance, 
                                      current_balance, is_active) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$name, $phone, $address, $opening_balance, $opening_balance, $is_active]);
                $company_id = $pdo->lastInsertId();
                
                // Create opening balance transaction
                $stmt = $pdo->prepare("INSERT INTO transactions (date, account_type, account_id, 
                                      debit_amount, credit_amount, balance_after, description) 
                                      VALUES (CURDATE(), 'company', ?, ?, ?, ?, ?)");
                $debit = $opening_balance >= 0 ? $opening_balance : 0;
                $credit = $opening_balance < 0 ? abs($opening_balance) : 0;
                $stmt->execute([$company_id, $debit, $credit, $opening_balance, 'رصيد افتتاحي للشركة']);
                
                echo json_encode(['success' => true, 'message' => 'تم إضافة الشركة بنجاح']);
            }
            break;
            
        case 'delete_company':
            $id = intval($_POST['id']);
            
            // Check if company has transactions other than opening balance
            $stmt = $pdo->prepare("SELECT COUNT(*) as cnt FROM transactions 
                                  WHERE account_type = 'company' AND account_id = ? 
                                  AND voucher_type IS NOT NULL");
            $stmt->execute([$id]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result['cnt'] > 0) {
                throw new Exception('لا يمكن حذف الشركة لأنها لديها حركات مالية');
            }
            
            // Delete transactions first (including opening balance)
            $stmt = $pdo->prepare("DELETE FROM transactions WHERE account_type = 'company' AND account_id = ?");
            $stmt->execute([$id]);
            
            // Delete company
            $stmt = $pdo->prepare("DELETE FROM companies WHERE id = ?");
            $stmt->execute([$id]);
            
            if ($stmt->rowCount() > 0) {
                echo json_encode(['success' => true, 'message' => 'تم حذف الشركة وجميع العمليات المرتبطة بها']);
            } else {
                throw new Exception('الشركة غير موجودة');
            }
            break;
            
        default:
            throw new Exception('عملية غير معروفة');
    }
    
    $pdo->commit();
    
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
