<?php
session_start();
require_once 'reports_vouchers/db.php';

header('Content-Type: application/json');

try {
    $pdo->beginTransaction();
    
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'get_customer':
            $id = intval($_POST['id']);
            $stmt = $pdo->prepare("SELECT * FROM customers WHERE id = ?");
            $stmt->execute([$id]);
            $customer = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($customer) {
                echo json_encode(['success' => true, 'data' => $customer]);
            } else {
                echo json_encode(['success' => false, 'message' => 'العميل غير موجود']);
            }
            break;
            
        case 'save_customer':
            $id = intval($_POST['customerId'] ?? 0);
            $name = trim($_POST['name']);
            $phone = trim($_POST['phone'] ?? '');
            $address = trim($_POST['address'] ?? '');
            $opening_balance = floatval($_POST['opening_balance']);
            $is_active = intval($_POST['is_active'] ?? 1);
            
            if (empty($name)) {
                throw new Exception('اسم العميل مطلوب');
            }
            
            if ($id > 0) {
                // Update existing customer
                $stmt = $pdo->prepare("SELECT opening_balance, current_balance FROM customers WHERE id = ?");
                $stmt->execute([$id]);
                $oldData = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // Calculate difference in opening balance
                $balance_diff = $opening_balance - $oldData['opening_balance'];
                
                // Update customer
                $stmt = $pdo->prepare("UPDATE customers SET name = ?, phone = ?, address = ?, 
                                      opening_balance = ?, current_balance = current_balance + ?, 
                                      is_active = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$name, $phone, $address, $opening_balance, $balance_diff, $is_active, $id]);
                
                // Update opening balance transaction
                $stmt = $pdo->prepare("UPDATE transactions SET 
                                      debit_amount = CASE WHEN ? >= 0 THEN ? ELSE 0 END,
                                      credit_amount = CASE WHEN ? < 0 THEN ABS(?) ELSE 0 END,
                                      balance_after = ?,
                                      updated_at = NOW()
                                      WHERE account_type = 'customer' AND account_id = ? 
                                      AND voucher_type IS NULL");
                $debit = $opening_balance >= 0 ? $opening_balance : 0;
                $credit = $opening_balance < 0 ? abs($opening_balance) : 0;
                $stmt->execute([$opening_balance, $debit, $opening_balance, $opening_balance, $opening_balance, $id]);
                
                echo json_encode(['success' => true, 'message' => 'تم تحديث بيانات العميل بنجاح']);
            } else {
                // Insert new customer
                $stmt = $pdo->prepare("INSERT INTO customers (name, phone, address, opening_balance, 
                                      current_balance, is_active) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$name, $phone, $address, $opening_balance, $opening_balance, $is_active]);
                $customer_id = $pdo->lastInsertId();
                
                // Create opening balance transaction
                $stmt = $pdo->prepare("INSERT INTO transactions (date, account_type, account_id, 
                                      debit_amount, credit_amount, balance_after, description) 
                                      VALUES (CURDATE(), 'customer', ?, ?, ?, ?, ?)");
                $debit = $opening_balance >= 0 ? $opening_balance : 0;
                $credit = $opening_balance < 0 ? abs($opening_balance) : 0;
                $stmt->execute([$customer_id, $debit, $credit, $opening_balance, 'رصيد افتتاحي للعميل']);
                
                echo json_encode(['success' => true, 'message' => 'تم إضافة العميل بنجاح']);
            }
            break;
            
        case 'delete_customer':
            $id = intval($_POST['id']);
            
            // Check if customer has transactions other than opening balance
            $stmt = $pdo->prepare("SELECT COUNT(*) as cnt FROM transactions 
                                  WHERE account_type = 'customer' AND account_id = ? 
                                  AND voucher_type IS NOT NULL");
            $stmt->execute([$id]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result['cnt'] > 0) {
                throw new Exception('لا يمكن حذف العميل لأنه لديه حركات مالية');
            }
            
            // Delete transactions first (including opening balance)
            $stmt = $pdo->prepare("DELETE FROM transactions WHERE account_type = 'customer' AND account_id = ?");
            $stmt->execute([$id]);
            
            // Delete customer
            $stmt = $pdo->prepare("DELETE FROM customers WHERE id = ?");
            $stmt->execute([$id]);
            
            if ($stmt->rowCount() > 0) {
                echo json_encode(['success' => true, 'message' => 'تم حذف العميل وجميع العمليات المرتبطة به']);
            } else {
                throw new Exception('العميل غير موجود');
            }
            break;
            
        default:
            throw new Exception('عملية غير معروفة');
    }
    
    $pdo->commit();
    
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}