<?php
// backup_debug.php - للمساعدة في تشخيص المشكلة
session_start();
require_once 'config/database.php';
require_once 'core/Database.php';
require_once 'core/Session.php';
require_once 'core/Auth.php';

$auth = new Auth();

if (!$auth->isLoggedIn()) {
    die('غير مصرح لك بالوصول');
}

echo "<h2>تشخيص النسخ الاحتياطي</h2>";

// التحقق من إضافة ZIP
echo "<h3>1. التحقق من إضافة ZIP:</h3>";
if (class_exists('ZipArchive')) {
    echo "<p style='color: green;'>✓ إضافة ZIP متوفرة</p>";
} else {
    echo "<p style='color: red;'>✗ إضافة ZIP غير متوفرة</p>";
}

// التحقق من مجلد backups
echo "<h3>2. التحقق من مجلد النسخ الاحتياطية:</h3>";
$backupDir = __DIR__ . '/backups';
if (file_exists($backupDir)) {
    echo "<p style='color: green;'>✓ مجلد backups موجود</p>";
    echo "<p>الصلاحيات: " . substr(sprintf('%o', fileperms($backupDir)), -4) . "</p>";
} else {
    echo "<p style='color: orange;'>⚠ مجلد backups غير موجود، سيتم إنشاؤه</p>";
    if (mkdir($backupDir, 0755, true)) {
        echo "<p style='color: green;'>✓ تم إنشاء المجلد بنجاح</p>";
    } else {
        echo "<p style='color: red;'>✗ فشل في إنشاء المجلد</p>";
    }
}

// التحقق من مجلد uploads
echo "<h3>3. التحقق من مجلد uploads:</h3>";
$uploadsDir = __DIR__ . '/uploads';
if (file_exists($uploadsDir) && is_dir($uploadsDir)) {
    $filesCount = count(glob($uploadsDir . '/*'));
    echo "<p style='color: green;'>✓ مجلد uploads موجود</p>";
    echo "<p>عدد الملفات: $filesCount</p>";
} else {
    echo "<p style='color: orange;'>⚠ مجلد uploads غير موجود</p>";
}

// التحقق من قاعدة البيانات
echo "<h3>4. التحقق من قاعدة البيانات:</h3>";
try {
    $db = Database::getInstance();
    $tables = $db->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<p style='color: green;'>✓ اتصال قاعدة البيانات ناجح</p>";
    echo "<p>عدد الجداول: " . count($tables) . "</p>";
    
    echo "<ul>";
    foreach ($tables as $table) {
        $count = $db->query("SELECT COUNT(*) as cnt FROM `$table`")->fetch()['cnt'];
        echo "<li>$table: $count سجل</li>";
    }
    echo "</ul>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ فشل الاتصال بقاعدة البيانات: " . $e->getMessage() . "</p>";
}

// اختبار إنشاء ملف ZIP
echo "<h3>5. اختبار إنشاء ملف ZIP:</h3>";
$testZipFile = $backupDir . '/test_backup.zip';

if (class_exists('ZipArchive')) {
    $zip = new ZipArchive();
    if ($zip->open($testZipFile, ZipArchive::CREATE) === TRUE) {
        // إضافة ملف نصي تجريبي
        $testContent = "هذا ملف اختبار للنسخ الاحتياطي\nتاريخ: " . date('Y-m-d H:i:s');
        if ($zip->addFromString('test.txt', $testContent)) {
            $zip->close();
            
            if (file_exists($testZipFile) && filesize($testZipFile) > 0) {
                echo "<p style='color: green;'>✓ تم إنشاء ملف ZIP بنجاح</p>";
                echo "<p>حجم الملف: " . filesize($testZipFile) . " بايت</p>";
                echo "<p><a href='$testZipFile' download>تحميل ملف الاختبار</a></p>";
                
                // قراءة محتوى الملف للتأكد
                $zip2 = new ZipArchive();
                if ($zip2->open($testZipFile) === TRUE) {
                    echo "<p>المحتويات:</p>";
                    for ($i = 0; $i < $zip2->numFiles; $i++) {
                        $filename = $zip2->getNameIndex($i);
                        echo "<p>- $filename</p>";
                    }
                    $zip2->close();
                }
            } else {
                echo "<p style='color: red;'>✗ تم إنشاء الملف لكنه فارغ</p>";
            }
        } else {
            echo "<p style='color: red;'>✗ فشل في إضافة محتوى إلى الأرشيف</p>";
        }
    } else {
        echo "<p style='color: red;'>✗ فشل في إنشاء ملف ZIP</p>";
    }
}

// زر لاختبار النسخ الاحتياطي الفعلي
echo "<h3>6. اختبار النسخ الاحتياطي الكامل:</h3>";
echo "<button onclick=\"testBackup()\" style='padding: 10px 20px; background: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer;'>اختبار النسخ الاحتياطي</button>";
echo "<div id='testResult' style='margin-top: 10px;'></div>";

?>

<script>
function testBackup() {
    document.getElementById('testResult').innerHTML = '<p>جاري الاختبار...</p>';
    
    fetch('create_backup.php')
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => {
                    throw new Error('خطأ: ' + text);
                });
            }
            return response.blob();
        })
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'test_backup.zip';
            document.body.appendChild(a);
            a.click();
            
            setTimeout(() => {
                window.URL.revokeObjectURL(url);
                document.body.removeChild(a);
            }, 1000);
            
            document.getElementById('testResult').innerHTML = 
                '<p style="color: green;">✓ تم إنشاء النسخة الاحتياطية بنجاح!</p>' +
                '<p>تم تحميل الملف تلقائياً</p>';
        })
        .catch(error => {
            document.getElementById('testResult').innerHTML = 
                '<p style="color: red;">✗ ' + error.message + '</p>';
        });
}
</script>