<?php
session_start();

require_once 'config/database.php'; // 🔥 هذا هو الحل
require_once 'core/Auth.php';

header('Content-Type: application/json; charset=utf-8');

$auth = new Auth();

if (!$auth->isLoggedIn()) {
    http_response_code(403);
    echo json_encode(['error' => 'غير مصرح']);
    exit;
}

$backupDir = __DIR__ . '/backups';

if (!is_dir($backupDir)) {
    echo json_encode(['lastBackup' => null]);
    exit;
}

$backupFiles = glob($backupDir . '/*.zip');

if (!$backupFiles) {
    echo json_encode(['lastBackup' => null]);
    exit;
}

usort($backupFiles, fn($a, $b) => filemtime($b) - filemtime($a));
$latest = $backupFiles[0];

echo json_encode([
    'lastBackup' => date('Y-m-d H:i', filemtime($latest)),
    'fileName'   => basename($latest),
    'fileSize'   => round(filesize($latest) / 1024 / 1024, 2) . ' MB'
]);
exit;
