<?php
// core/Session.php
class Session {
    public function __construct() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }
    
    public function set($key, $value) {
        $_SESSION[$key] = $value;
    }
    
    public function get($key, $default = null) {
        return $_SESSION[$key] ?? $default;
    }
    
    public function has($key) {
        return isset($_SESSION[$key]);
    }
    
    public function remove($key) {
        if (isset($_SESSION[$key])) {
            unset($_SESSION[$key]);
        }
    }
    
    public function destroy() {
        session_destroy();
    }
    
    public function setFlash($message, $type = 'success') {
        $this->set('flash', ['message' => $message, 'type' => $type]);
    }
    
    public function getFlash() {
        $flash = $this->get('flash');
        $this->remove('flash');
        return $flash;
    }
    
    public function setUser($user) {
        $this->set('user', $user);
        $this->set('user_last_activity', time());
    }
    
    public function getUser() {
        return $this->get('user');
    }
    
    public function isLoggedIn() {
        if (!$this->has('user')) {
            return false;
        }
        
        // التحقق من انتهاء الجلسة
        $lastActivity = $this->get('user_last_activity');
        if (time() - $lastActivity > SESSION_TIMEOUT) {
            $this->destroy();
            return false;
        }
        
        $this->set('user_last_activity', time());
        return true;
    }
}
?>