<?php
session_start();
require_once 'InvoiceManager.php';

$invoiceManager = new InvoiceManager();
$message = '';
$error = '';

// جلب العملاء والعملات
$db = Config::getDB();
$customers = $db->query("SELECT id, name FROM customers WHERE is_active = 1")->fetchAll();

// جلب العملات النشطة
$currencies = $db->query("SELECT id, name, code, exchange_rate, is_default FROM currencies WHERE is_active = 1 ORDER BY is_default DESC")->fetchAll();

// البحث عن العملة الافتراضية
$defaultCurrency = null;
foreach ($currencies as $currency) {
    if ($currency['is_default']) {
        $defaultCurrency = $currency;
        break;
    }
}

if (!$defaultCurrency) {
    $error = "يجب تحديد عملة افتراضية في النظام أولاً";
}

// معالجة إنشاء فاتورة جديدة
if ($_POST['action'] ?? '' === 'create_invoice') {
    try {
        // جمع أسعار الصرف من النموذج
        $exchangeRates = [];
        foreach ($currencies as $currency) {
            $inputName = 'exchange_rate_' . $currency['id'];
            if (isset($_POST[$inputName]) && $_POST[$inputName] != '') {
                $exchangeRates[$currency['id']] = floatval($_POST[$inputName]);
            }
        }
        
        $invoiceId = $invoiceManager->createInvoice([
            'customer_id' => $_POST['customer_id'],
            'currency_id' => $defaultCurrency['id'], // استخدام العملة الافتراضية دائماً
            'exchange_rate' => $exchangeRates[$defaultCurrency['id']] ?? 1, // سعر الصرف للعملة الافتراضية
            'office_commission' => $_POST['office_commission'] ?? 0,
            'shipping_costs' => $_POST['shipping_costs'] ?? 0,
            'certificate_costs' => $_POST['certificate_costs'] ?? 0,
            'created_by' => $_SESSION['user_id'] ?? 1,
            'exchange_rates' => $exchangeRates // إضافة أسعار الصرف لجميع العملات
        ]);
        
        $_SESSION['message'] = "تم إنشاء الفاتورة بنجاح";
        header("Location: invoice_items.php?invoice_id=" . $invoiceId);
        exit;
        
    } catch(Exception $e) {
        $error = "خطأ في إنشاء الفاتورة: " . $e->getMessage();
    }
}
?>
<script src="jquery-3.6.0.min.js"></script>
     <link href="bootstrap.min.css" rel="stylesheet">
   <link href="select2.min.css" rel="stylesheet" />
   <script src="bootstrap.bundle.min.js"></script>
   <script src="select2.min.js"></script>
<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; margin: 5px auto; max-width: 1000px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-plus-circle" style="margin-left: 8px;"></i>
                إنشاء فاتورة جديدة
            </h2>
            <a href="invoices.php" class="btn" 
               style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
               onmouseover="this.style.background='#7f8c8d'"
               onmouseout="this.style.background='#95a5a6'">
                <i class="fas fa-arrow-right" style="margin-left: 8px;"></i>
                العودة للفواتير
            </a>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- رسائل الخطأ -->
        <?php if ($error): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #dc3545;"></i>
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #721c24; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if (!$defaultCurrency): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #fef9e7; color: #856404; border: 1px solid #ffeaa7; border-radius: 0; display: flex; align-items: center;">
                <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #f39c12;"></i>
                لم يتم تحديد عملة افتراضية في النظام. الرجاء التواصل مع المسؤول.
            </div>
        <?php endif; ?>

        <!-- نموذج إنشاء الفاتورة -->
        <div style="padding: 20px;">
            <form method="POST" id="invoiceForm">
                <input type="hidden" name="action" value="create_invoice">
                
                <!-- معلومات العميل والعملة -->
                <div style="margin-bottom: 25px;">
                    <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                        <i class="fas fa-user" style="margin-left: 8px;"></i>
                        معلومات العميل والعملة
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
                        <!-- العميل -->
                        <div>
                            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #2c3e50;">
                                <span style="color: #e74c3c;">*</span> العميل
                            </label>
                            <select name="customer_id" class="form-control select2" required
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white;"
                                    onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)'"
                                    onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none'">
                                <option value="">اختر العميل</option>
                                <?php foreach($customers as $customer): ?>
                                    <option value="<?php echo $customer['id']; ?>">
                                        <?php echo htmlspecialchars($customer['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <!-- العملة الافتراضية -->
                        <div>
                            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #2c3e50;">
                                <span style="color: #e74c3c;">*</span> عملة الفاتورة
                            </label>
                            <div style="display: flex; align-items: center; background: #f8f9fa; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0;">
                                <span style="background: #2ecc71; color: white; padding: 4px 8px; font-size: 12px; font-weight: 600; margin-left: 8px;">
                                    افتراضي
                                </span>
                                <span style="color: #2c3e50; font-weight: 500;">
                                    <?php echo htmlspecialchars($defaultCurrency['name'] ?? ''); ?> 
                                    (<?php echo htmlspecialchars($defaultCurrency['code'] ?? ''); ?>)
                                </span>
                                <input type="hidden" name="default_currency_id" value="<?php echo $defaultCurrency['id'] ?? ''; ?>">
                            </div>
                            <small style="color: #7f8c8d; font-size: 12px; margin-top: 5px; display: block;">
                                العملة الافتراضية للفاتورة لا يمكن تغييرها
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- أسعار الصرف -->
                <div style="margin-bottom: 25px;">
                    <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                        <i class="fas fa-exchange-alt" style="margin-left: 8px;"></i>
                        أسعار الصرف الحالية
                    </h4>
                    
                    <div style="background: #f8f9fa; padding: 15px; border: 1px solid #ecf0f1; margin-bottom: 15px;">
                        <div style="font-size: 14px; color: #7f8c8d; margin-bottom: 10px; display: flex; align-items: center;">
                            <i class="fas fa-info-circle" style="margin-left: 8px;"></i>
                            يجب إدخال أسعار الصرف الحالية لجميع العملات في وقت إنشاء الفاتورة
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
                            <?php foreach($currencies as $currency): ?>
                                <div style="background: white; padding: 12px; border: 1px solid #ecf0f1; border-radius: 0;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                                        <label style="font-weight: 600; color: #2c3e50; display: flex; align-items: center;">
                                            <?php if($currency['is_default']): ?>
                                                <span style="background: #2ecc71; color: white; padding: 2px 6px; font-size: 11px; font-weight: 600; margin-left: 8px;">
                                                    افتراضي
                                                </span>
                                            <?php endif; ?>
                                            <?php echo htmlspecialchars($currency['name']); ?> (<?php echo htmlspecialchars($currency['code']); ?>)
                                        </label>
                                        <?php if($currency['is_default']): ?>
                                            <span style="font-size: 12px; color: #7f8c8d;">
                                                سعر الصرف = 1 دائماً
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div style="display: flex; align-items: center; gap: 8px;">
                                        <div style="flex: 1; display: flex; align-items: center;">
                                            <span style="background: #e8f4fd; padding: 8px 12px; border: 1px solid #bdc3c7; border-right: none; font-size: 14px; color: #3498db; min-width: 120px;">
                                                1 <?php echo htmlspecialchars($defaultCurrency['code']); ?> =
                                            </span>
                                            <input type="number" 
                                                   name="exchange_rate_<?php echo $currency['id']; ?>" 
                                                   style="flex: 1; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; text-align: left;"
                                                   step="0.000001" 
                                                   value="<?php echo $currency['is_default'] ? '1.000000' : number_format($currency['exchange_rate'], 6); ?>"
                                                   <?php echo $currency['is_default'] ? 'readonly' : ''; ?>
                                                   required
                                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)'"
                                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none'">
                                        </div>
                                        <span style="background: #e8f4fd; padding: 8px 12px; border: 1px solid #bdc3c7; border-left: none; font-size: 14px; color: #3498db; min-width: 60px; text-align: center;">
                                            <?php echo htmlspecialchars($currency['code']); ?>
                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                
                <!-- التكاليف الإضافية -->
                <div style="margin-bottom: 25px;">
                    <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                        <i class="fas fa-money-bill-wave" style="margin-left: 8px;"></i>
                        التكاليف الإضافية (اختياري)
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
                        <!-- عمولة المكتب -->
                        <div>
                            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #2c3e50;">
                                عمولة المكتب
                            </label>
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <input type="number" 
                                       name="office_commission" 
                                       value="0" 
                                       step="0.01"
                                       style="flex: 1; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)'"
                                       onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none'">
                                <span style="background: #e8f4fd; padding: 10px 12px; border: 1px solid #bdc3c7; font-size: 14px; color: #3498db; min-width: 60px; text-align: center;">
                                    <?php echo htmlspecialchars($defaultCurrency['code'] ?? ''); ?>
                                </span>
                            </div>
                        </div>
                        
                        <!-- تكاليف الشحن -->
                        <div>
                            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #2c3e50;">
                                تكاليف الشحن
                            </label>
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <input type="number" 
                                       name="shipping_costs" 
                                       value="0" 
                                       step="0.01"
                                       style="flex: 1; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)'"
                                       onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none'">
                                <span style="background: #e8f4fd; padding: 10px 12px; border: 1px solid #bdc3c7; font-size: 14px; color: #3498db; min-width: 60px; text-align: center;">
                                    <?php echo htmlspecialchars($defaultCurrency['code'] ?? ''); ?>
                                </span>
                            </div>
                        </div>
                        
                        <!-- مصاريف الشهادات -->
                        <div>
                            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #2c3e50;">
                                مصاريف الشهادات
                            </label>
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <input type="number" 
                                       name="certificate_costs" 
                                       value="0" 
                                       step="0.01"
                                       style="flex: 1; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)'"
                                       onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none'">
                                <span style="background: #e8f4fd; padding: 10px 12px; border: 1px solid #bdc3c7; font-size: 14px; color: #3498db; min-width: 60px; text-align: center;">
                                    <?php echo htmlspecialchars($defaultCurrency['code'] ?? ''); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- زر الإنشاء -->
                <div style="display: flex; justify-content: flex-end; gap: 10px; padding-top: 20px; border-top: 1px solid #ecf0f1;">
                    <a href="invoices.php" class="btn" 
                       style="padding: 10px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 10px 20px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'"
                            <?php echo !$defaultCurrency ? 'disabled' : ''; ?>>
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        إنشاء الفاتورة والمتابعة لإضافة الأصناف
                    </button>
                </div>
            </form>
        </div>
        
        <!-- ملاحظات هامة -->
        <div style="padding: 15px 20px; background: #f8f9fa; border-top: 1px solid #ecf0f1;">
            <h4 style="color: #2c3e50; margin-bottom: 10px; font-size: 16px; display: flex; align-items: center;">
                <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                ملاحظات هامة:
            </h4>
            <ul style="margin: 0; padding-right: 20px; color: #7f8c8d; font-size: 14px;">
                <li style="margin-bottom: 5px;">عملة الفاتورة ثابتة على العملة الافتراضية للنظام (<?php echo htmlspecialchars($defaultCurrency['name'] ?? ''); ?>)</li>
                <li style="margin-bottom: 5px;">يجب إدخال أسعار الصرف الحالية لجميع العملات في وقت إنشاء الفاتورة</li>
                <li style="margin-bottom: 5px;">سيتم حفظ أسعار الصرف في سجل خاص لكل فاتورة لتوثيق القيم التاريخية</li>
                <li>سعر صرف العملة الافتراضية دائماً يساوي 1</li>
            </ul>
        </div>
    </div>
</div>

<!-- نافذة التحميل -->
<div id="loadingModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; padding: 30px; border-radius: 0; text-align: center; min-width: 300px;">
        <div style="margin-bottom: 15px;">
            <i class="fas fa-spinner fa-spin fa-2x" style="color: #3498db;"></i>
        </div>
        <div style="font-weight: 600; color: #2c3e50; margin-bottom: 10px;">
            جاري إنشاء الفاتورة...
        </div>
        <div style="font-size: 14px; color: #7f8c8d;">
            الرجاء الانتظار
        </div>
    </div>
</div>

<style>
    /* تنسيقات إضافية متناسقة مع واجهة الأصناف */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
    
    /* تنسيق select2 متناسق */
    .select2-container--default .select2-selection--single {
        border: 1px solid #bdc3c7 !important;
        border-radius: 0 !important;
        height: auto !important;
        padding: 9px 12px !important;
        font-size: 14px !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #2c3e50 !important;
        line-height: 1.5 !important;
        padding: 0 !important;
        text-align: right !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 100% !important;
        left: 12px !important;
        right: auto !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        border-color: #2c3e50 transparent transparent transparent !important;
        border-width: 6px 6px 0 6px !important;
    }
    
    .select2-container--default.select2-container--open .select2-selection--single .select2-selection__arrow b {
        border-color: transparent transparent #2c3e50 transparent !important;
        border-width: 0 6px 6px 6px !important;
    }
    
    .select2-container--default .select2-dropdown {
        border: 1px solid #bdc3c7 !important;
        border-radius: 0 !important;
    }
    
    .select2-container--default .select2-results__option--highlighted[aria-selected] {
        background-color: #3498db !important;
        color: white !important;
    }
    
    /* تحسين التجاوب مع الجوال */
    @media (max-width: 768px) {
        .card {
            margin: 5px;
        }
        
        .card-header h2 {
            font-size: 16px;
        }
        
        .btn {
            padding: 8px 12px !important;
            font-size: 13px !important;
        }
        
        input, select, .select2-container--default .select2-selection--single {
            font-size: 13px !important;
            padding: 8px 10px !important;
        }
    }
</style>


<script>
// تهيئة select2
$(document).ready(function() {
    $('.select2').select2({
        dir: 'rtl',
        width: '100%',
    
    }).on('select2:open', function() {
        setTimeout(function() {
            var field = document.querySelector('.select2-container--open .select2-search__field');
            if (field) field.focus();
        }, 0);
    });
});

// التحقق من صحة الأسعار قبل الإرسال
document.getElementById('invoiceForm').addEventListener('submit', function(e) {
    // إظهار نافذة التحميل
    document.getElementById('loadingModal').style.display = 'flex';
    
    const exchangeRates = document.querySelectorAll('input[name^="exchange_rate_"]');
    let isValid = true;
    
    exchangeRates.forEach(input => {
        const value = parseFloat(input.value);
        if (isNaN(value) || value <= 0) {
            isValid = false;
            input.style.borderColor = '#e74c3c';
            input.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        document.getElementById('loadingModal').style.display = 'none';
        alert('الرجاء إدخال قيم صحيحة لأسعار الصرف (يجب أن تكون أكبر من صفر)');
    }
    
    // التحقق من اختيار العميل
    const customerSelect = document.querySelector('select[name="customer_id"]');
    if (!customerSelect.value) {
        e.preventDefault();
        document.getElementById('loadingModal').style.display = 'none';
        customerSelect.style.borderColor = '#e74c3c';
        customerSelect.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('الرجاء اختيار عميل');
        return;
    }
});

// تحديث القيم الافتراضية عند التحميل
document.addEventListener('DOMContentLoaded', function() {
    const defaultCurrencyInput = document.querySelector('input[name="exchange_rate_' + <?php echo $defaultCurrency['id'] ?? 0; ?> + '"]');
    if (defaultCurrencyInput) {
        defaultCurrencyInput.value = '1.000000';
        defaultCurrencyInput.readOnly = true;
        defaultCurrencyInput.style.backgroundColor = '#f8f9fa';
        defaultCurrencyInput.style.cursor = 'not-allowed';
    }
    
    // إضافة تأثيرات لحقول الإدخال
    const inputs = document.querySelectorAll('input[type="number"], select');
    inputs.forEach(input => {
        input.addEventListener('focus', function() {
            this.style.borderColor = '#3498db';
            this.style.boxShadow = '0 0 0 2px rgba(52,152,219,0.2)';
        });
        
        input.addEventListener('blur', function() {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        });
    });
    
    // منع إرسال النموذج إذا كانت العملة الافتراضية غير محددة
    const submitBtn = document.querySelector('button[type="submit"]');
    if (!<?php echo $defaultCurrency ? 'true' : 'false'; ?>) {
        submitBtn.disabled = true;
        submitBtn.style.backgroundColor = '#95a5a6';
        submitBtn.style.cursor = 'not-allowed';
        submitBtn.onmouseover = null;
        submitBtn.onmouseout = null;
    }
});

// وظائف إضافية
function showLoading() {
    document.getElementById('loadingModal').style.display = 'flex';
}

function hideLoading() {
    document.getElementById('loadingModal').style.display = 'none';
}

// إغلاق نافذة التحميل عند النقر خارجها (اختياري)
document.getElementById('loadingModal').addEventListener('click', function(e) {
    if (e.target === this) {
        this.style.display = 'none';
    }
});
</script>

<?php
include 'views/layout/footer.php';
?>