<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/config.php';

header('Content-Type: application/json; charset=utf-8');

$db = Config::getDB();
$invoiceId = $_GET['invoice_id'] ?? null;

if (!$invoiceId) {
    echo json_encode(['success' => false, 'message' => 'معرف الفاتورة مطلوب']);
    exit;
}

// جلب العملة الافتراضية للفاتورة
$stmt = $db->prepare("
    SELECT i.currency_id, cr.code AS base_currency_code
    FROM invoices i
    LEFT JOIN currencies cr ON i.currency_id = cr.id
    WHERE i.id = ?
");
$stmt->execute([$invoiceId]);
$invoice = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invoice) {
    echo json_encode(['success' => false, 'message' => 'الفاتورة غير موجودة']);
    exit;
}

// جلب أسعار الصرف
$stmt = $db->prepare("
    SELECT 
        ier.currency_id,
        ier.exchange_rate,
        ier.is_local,
        cr.name AS currency_name,
        cr.code AS currency_code
    FROM invoice_exchange_rates ier
    LEFT JOIN currencies cr ON ier.currency_id = cr.id
    WHERE ier.invoice_id = ?
    ORDER BY ier.is_local DESC, cr.code
");
$stmt->execute([$invoiceId]);
$currencies = $stmt->fetchAll(PDO::FETCH_ASSOC);

// إذا لم توجد أسعار صرف
if (empty($currencies)) {
    $stmt = $db->prepare("
        SELECT 
            cr.id AS currency_id,
            cr.name AS currency_name,
            cr.code AS currency_code,
            1 AS exchange_rate,
            1 AS is_local
        FROM currencies cr
        WHERE cr.id = ?
    ");
    $stmt->execute([$invoice['currency_id']]);
    $currencies = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

echo json_encode([
    'success' => true,
    'base_currency' => $invoice['base_currency_code'] ?? 'LOCAL',
    'currencies' => $currencies
]);
