<?php
session_start();
require_once 'config.php';
require_once 'InvoiceManager.php';

header('Content-Type: application/json');

$invoiceId = $_GET['invoice_id'] ?? 0;

if (!$invoiceId) {
    echo json_encode(['success' => false, 'message' => 'معرف الفاتورة مطلوب']);
    exit;
}

try {
    $invoiceManager = new InvoiceManager();
    $invoice = $invoiceManager->getInvoice($invoiceId);
    $items = $invoiceManager->getInvoiceItems($invoiceId);
    
    if ($invoice) {
        echo json_encode([
            'success' => true,
            'invoice' => $invoice,
            'items' => $items
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'لم يتم العثور على الفاتورة']);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>