<?php
session_start();
require_once 'InvoiceManager.php';

header('Content-Type: application/json');

$invoiceId = $_GET['invoice_id'] ?? 0;

if (!$invoiceId) {
    echo json_encode(['success' => false, 'message' => 'معرف الفاتورة مطلوب']);
    exit;
}

try {
    $invoiceManager = new InvoiceManager();
    $totals = $invoiceManager->getInvoiceTotals($invoiceId);
    
    if ($totals) {
        echo json_encode([
            'success' => true,
            'items_total' => $totals['items_total'],
            'total_amount' => $totals['total_amount'],
            'total_amount_local' => $totals['total_amount_local']
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'لم يتم العثور على الفاتورة']);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>