<?php
// index.php
require_once 'config/database.php';
require_once 'core/Database.php';
require_once 'core/Session.php';
require_once 'core/Auth.php';

$session = new Session();
$auth = new Auth();

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

// جلب معلومات المستخدم الحالي
$currentUser = $auth->getUser();

// إذا لم يتم العثور على المستخدم، استخدام بيانات افتراضية
if (!$currentUser) {
    $currentUser = [
        'id' => 0,
        'username' => 'مستخدم',
        'full_name' => 'مستخدم النظام',
        'role_name' => 'زائر'
    ];
}

// حساب الإحصائيات الحقيقية
$db = Database::getInstance();

// عدد العملاء
$customersCount = $db->query("SELECT COUNT(*) as count FROM customers")->fetch()['count'];

// عدد الفواتير
$invoicesCount = $db->query("SELECT COUNT(*) as count FROM invoices")->fetch()['count'];

// عدد المستخدمين
$usersCount = $db->query("SELECT COUNT(*) as count FROM users")->fetch()['count'];

// عدد الأصناف
$itemsCount = $db->query("SELECT COUNT(*) as count FROM items")->fetch()['count'];

// إجمالي المبيعات (مجموع الفواتير المرحلة)
$totalSales = $db->query("SELECT SUM(total_amount_local) as total FROM invoices WHERE status = 'confirmed'")->fetch()['total'];
$totalSales = $totalSales ? $totalSales : 0;

// عدد الفواتير هذا الشهر
$currentMonth = date('Y-m');
$monthlyInvoices = $db->query("SELECT COUNT(*) as count FROM invoices WHERE DATE_FORMAT(created_at, '%Y-%m') = '$currentMonth'")->fetch()['count'];

// حساب نسبة النمو
$lastMonth = date('Y-m', strtotime('-1 month'));
$lastMonthInvoices = $db->query("SELECT COUNT(*) as count FROM invoices WHERE DATE_FORMAT(created_at, '%Y-%m') = '$lastMonth'")->fetch()['count'];
$growthRate = $lastMonthInvoices > 0 ? (($monthlyInvoices - $lastMonthInvoices) / $lastMonthInvoices) * 100 : 0;

include 'views/layout/header.php';
?>

<!-- Loader للنسخ الاحتياطي -->
<div id="backupLoader" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 99999; align-items: center; justify-content: center;">
    <div style="background: white; padding: 30px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2); max-width: 400px;">
        <div style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #3498db; border-radius: 50%; margin: 0 auto 20px; animation: spin 1s linear infinite;"></div>
        <h3 style="color: #2c3e50; margin-bottom: 15px; font-weight: 600; font-size: 18px;">
            <i class="fas fa-database" style="margin-left: 8px;"></i>
            جاري إنشاء النسخة الاحتياطية
        </h3>
        <p style="color: #7f8c8d; margin-bottom: 10px; font-size: 14px;" id="backupMessage">جاري تصدير جداول قاعدة البيانات...</p>
        <div style="width: 100%; background: #ecf0f1; border-radius: 0; height: 10px; margin-bottom: 20px;">
            <div id="backupProgress" style="width: 0%; height: 100%; background: #3498db; border-radius: 0; transition: width 0.3s;"></div>
        </div>
        <p style="font-size: 12px; color: #95a5a6;">يرجى الانتظار، قد تستغرق العملية بضع دقائق...</p>
    </div>
</div>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; padding: 10px; padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-home" style="margin-left: 8px;"></i>
                الصفحة الرئيسية
            </h2>
            <div style="display: flex; align-items: center; gap: 10px;">
                <div style="background: rgba(241, 158, 44, 0.3); padding: 6px 12px; border-radius: 0; display: inline-flex; align-items: center; font-size: 13px;">
                    <i class="fas fa-user-shield" style="margin-left: 8px;"></i>
                    <?php echo htmlspecialchars($currentUser['role_name'] ?? 'مستخدم'); ?>
                </div>
                <?php if ($auth->checkPermission('backup', 'create')): ?>
                <button onclick="createBackup()" style="padding: 8px 16px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 13px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#c0392b'"
                        onmouseout="this.style.background='#e74c3c'">
                    <i class="fas fa-database" style="margin-left: 8px;"></i>
                    نسخة احتياطية
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- قسم الترحيب -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1; background: linear-gradient(135deg, #0E4262 0%, #1A5A7A 100%); color: white;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
                <div>
                    <h1 style="font-size: 22px; margin-bottom: 8px; font-weight: 600;">
                        مرحباً بك، <?php echo htmlspecialchars($currentUser['full_name'] ?? $currentUser['username']); ?>
                    </h1>
                    <p style="opacity: 0.9; margin-bottom: 10px; font-size: 13px;">نظام إدارة GTS لمعدات المطبخ المحدودة</p>
                    <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                        <div style="background: rgba(255,255,255,0.15); padding: 5px 10px; border-radius: 0; display: inline-flex; align-items: center; font-size: 12px;">
                            <i class="fas fa-clock" style="margin-left: 5px;"></i>
                            <?php echo date('Y-m-d H:i'); ?>
                        </div>
                        <?php if (isset($currentUser['last_login'])): ?>
                        <div style="background: rgba(52, 152, 219, 0.3); padding: 5px 10px; border-radius: 0; display: inline-flex; align-items: center; font-size: 12px;">
                            <i class="fas fa-sign-in-alt" style="margin-left: 5px;"></i>
                            آخر دخول: <?php echo date('Y-m-d H:i', strtotime($currentUser['last_login'])); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div>
                    <?php if (file_exists('logo.png')): ?>
                    <img src="logo.png" alt="GTS لمعدات المطبخ المحدودة" style="max-width: 120px; height: auto; filter: drop-shadow(0 5px 15px rgba(0,0,0,0.3));">
                    <?php else: ?>
                    <div style="background: rgba(255,255,255,0.1); padding: 12px; border-radius: 0; text-align: center; min-width: 120px;">
                        <div style="font-size: 20px; font-weight: bold; color: #F19E2C;">GTS</div>
                        <div style="font-size: 10px; opacity: 0.9; margin-top: 3px;">لمعدات المطبخ المحدودة</div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- الإحصائيات السريعة -->
        <div style="padding: 15px 20px; border-bottom: 1px solid #ecf0f1;">
            <h3 style="color: #2c3e50; margin-bottom: 15px; font-weight: 600; font-size: 16px; display: flex; align-items: center;">
                <i class="fas fa-chart-line" style="margin-left: 8px; color: #F19E2C;"></i>
                نظرة عامة على النظام
            </h3>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 10px; margin-bottom: 15px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c; display: flex; align-items: center; gap: 12px;">
                    <div style="width: 40px; height: 40px; background: rgba(26, 188, 156, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-users" style="font-size: 20px; color: #1abc9c;"></i>
                    </div>
                    <div>
                        <div style="font-size: 11px; color: #7f8c8d; margin-bottom: 3px;">العملاء</div>
                        <div style="font-size: 22px; font-weight: bold; color: #16a085;"><?php echo number_format($customersCount); ?></div>
                    </div>
                </div>
                
                <div style="background: #e8f4fd; padding: 15px; border-left: 4px solid #3498db; display: flex; align-items: center; gap: 12px;">
                    <div style="width: 40px; height: 40px; background: rgba(52, 152, 219, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-file-invoice" style="font-size: 20px; color: #3498db;"></i>
                    </div>
                    <div>
                        <div style="font-size: 11px; color: #7f8c8d; margin-bottom: 3px;">الفواتير</div>
                        <div style="font-size: 22px; font-weight: bold; color: #2980b9;"><?php echo number_format($invoicesCount); ?></div>
                    </div>
                </div>
                
                <div style="background: #f4ecf7; padding: 15px; border-left: 4px solid #9b59b6; display: flex; align-items: center; gap: 12px;">
                    <div style="width: 40px; height: 40px; background: rgba(155, 89, 182, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-user-cog" style="font-size: 20px; color: #9b59b6;"></i>
                    </div>
                    <div>
                        <div style="font-size: 11px; color: #7f8c8d; margin-bottom: 3px;">المستخدمين</div>
                        <div style="font-size: 22px; font-weight: bold; color: #8e44ad;"><?php echo number_format($usersCount); ?></div>
                    </div>
                </div>
                
                <div style="background: #fdedec; padding: 15px; border-left: 4px solid #e74c3c; display: flex; align-items: center; gap: 12px;">
                    <div style="width: 40px; height: 40px; background: rgba(231, 76, 60, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-boxes" style="font-size: 20px; color: #e74c3c;"></i>
                    </div>
                    <div>
                        <div style="font-size: 11px; color: #7f8c8d; margin-bottom: 3px;">الأصناف</div>
                        <div style="font-size: 22px; font-weight: bold; color: #c0392b;"><?php echo number_format($itemsCount); ?></div>
                    </div>
                </div>
            </div>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 10px; margin-top: 15px;">
                <div style="background: white; border: 1px solid #e0e0e0; padding: 15px;">
                    <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px;">
                        <div style="width: 36px; height: 36px; background: rgba(39, 174, 96, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-money-bill-wave" style="font-size: 16px; color: #27ae60;"></i>
                        </div>
                        <div>
                            <div style="font-size: 12px; color: #7f8c8d;">المبيعات الإجمالية</div>
                            <div style="font-size: 18px; font-weight: bold; color: #27ae60;">
                                <?php echo number_format($totalSales, 2); ?> 
                                <span style="font-size: 12px;">CNY</span>
                            </div>
                        </div>
                    </div>
                    <div style="font-size: 11px; color: #95a5a6;">إجمالي قيمة الفواتير المرحلة</div>
                </div>
                
                <div style="background: white; border: 1px solid #e0e0e0; padding: 15px;">
                    <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px;">
                        <div style="width: 36px; height: 36px; background: rgba(52, 152, 219, 0.2); border-radius: 0; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-calendar-alt" style="font-size: 16px; color: #3498db;"></i>
                        </div>
                        <div>
                            <div style="font-size: 12px; color: #7f8c8d;">النشاط الشهري</div>
                            <div style="font-size: 18px; font-weight: bold; color: #3498db;">
                                <?php echo number_format($monthlyInvoices); ?> فاتورة
                            </div>
                        </div>
                    </div>
                    <div style="display: flex; align-items: center; gap: 8px;">
                        <div style="font-size: 11px; color: #95a5a6;">هذا الشهر</div>
                        <?php if ($growthRate != 0): ?>
                            <div style="display: inline-flex; align-items: center; padding: 2px 6px; border-radius: 0; background: <?php echo $growthRate > 0 ? '#e8f6f3' : '#fdedec'; ?>; color: <?php echo $growthRate > 0 ? '#16a085' : '#e74c3c'; ?>; font-size: 10px;">
                                <i class="fas fa-arrow-<?php echo $growthRate > 0 ? 'up' : 'down'; ?>" style="margin-left: 3px; font-size: 9px;"></i>
                                <?php echo number_format(abs($growthRate), 1); ?>%
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- الوصول السريع -->
        <div style="padding: 15px 20px; border-bottom: 1px solid #ecf0f1;">
            <h3 style="color: #2c3e50; margin-bottom: 15px; font-weight: 600; font-size: 16px; display: flex; align-items: center;">
                <i class="fas fa-bolt" style="margin-left: 8px; color: #F19E2C;"></i>
                الوصول السريع
            </h3>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); gap: 10px;">
                <?php if ($auth->checkPermission('customers', 'read')): ?>
                <a href="customers.php" style="text-decoration: none;">
                    <div style="border: 1px solid #dee2e6; padding: 12px; text-align: center; transition: all 0.3s; cursor: pointer; background: white;"
                         onmouseover="this.style.borderColor='#3498db';this.style.boxShadow='0 3px 10px rgba(0,0,0,0.08)'"
                         onmouseout="this.style.borderColor='#dee2e6';this.style.boxShadow='none'">
                        <div style="width: 40px; height: 40px; background: #3498db; border-radius: 0; display: flex; align-items: center; justify-content: center; margin: 0 auto 8px; color: white;">
                            <i class="fas fa-users" style="font-size: 16px;"></i>
                        </div>
                        <div style="font-weight: 600; color: #2c3e50; font-size: 13px; margin-bottom: 3px;">العملاء</div>
                        <div style="font-size: 11px; color: #7f8c8d;">إدارة قاعدة العملاء</div>
                    </div>
                </a>
                <?php endif; ?>
                
                <?php if ($auth->checkPermission('invoices', 'read')): ?>
                <a href="invoices.php" style="text-decoration: none;">
                    <div style="border: 1px solid #dee2e6; padding: 12px; text-align: center; transition: all 0.3s; cursor: pointer; background: white;"
                         onmouseover="this.style.borderColor='#2ecc71';this.style.boxShadow='0 3px 10px rgba(0,0,0,0.08)'"
                         onmouseout="this.style.borderColor='#dee2e6';this.style.boxShadow='none'">
                        <div style="width: 40px; height: 40px; background: #2ecc71; border-radius: 0; display: flex; align-items: center; justify-content: center; margin: 0 auto 8px; color: white;">
                            <i class="fas fa-file-invoice" style="font-size: 16px;"></i>
                        </div>
                        <div style="font-weight: 600; color: #2c3e50; font-size: 13px; margin-bottom: 3px;">الفواتير</div>
                        <div style="font-size: 11px; color: #7f8c8d;">إنشاء وعرض الفواتير</div>
                    </div>
                </a>
                <?php endif; ?>
                
                <?php if ($auth->checkPermission('items', 'read')): ?>
                <a href="items.php" style="text-decoration: none;">
                    <div style="border: 1px solid #dee2e6; padding: 12px; text-align: center; transition: all 0.3s; cursor: pointer; background: white;"
                         onmouseover="this.style.borderColor='#e74c3c';this.style.boxShadow='0 3px 10px rgba(0,0,0,0.08)'"
                         onmouseout="this.style.borderColor='#dee2e6';this.style.boxShadow='none'">
                        <div style="width: 40px; height: 40px; background: #e74c3c; border-radius: 0; display: flex; align-items: center; justify-content: center; margin: 0 auto 8px; color: white;">
                            <i class="fas fa-boxes" style="font-size: 16px;"></i>
                        </div>
                        <div style="font-weight: 600; color: #2c3e50; font-size: 13px; margin-bottom: 3px;">الأصناف</div>
                        <div style="font-size: 11px; color: #7f8c8d;">إدارة المخزون</div>
                    </div>
                </a>
                <?php endif; ?>
                
                <?php if ($auth->checkPermission('reports', 'read') || $auth->checkPermission('accounts', 'read')): ?>
                <a href="reports_vouchers/accounts.php" style="text-decoration: none;">
                    <div style="border: 1px solid #dee2e6; padding: 12px; text-align: center; transition: all 0.3s; cursor: pointer; background: white;"
                         onmouseover="this.style.borderColor='#9b59b6';this.style.boxShadow='0 3px 10px rgba(0,0,0,0.08)'"
                         onmouseout="this.style.borderColor='#dee2e6';this.style.boxShadow='none'">
                        <div style="width: 40px; height: 40px; background: #9b59b6; border-radius: 0; display: flex; align-items: center; justify-content: center; margin: 0 auto 8px; color: white;">
                            <i class="fas fa-chart-bar" style="font-size: 16px;"></i>
                        </div>
                        <div style="font-weight: 600; color: #2c3e50; font-size: 13px; margin-bottom: 3px;">التقارير</div>
                        <div style="font-size: 11px; color: #7f8c8d;">تقارير وتحليلات</div>
                    </div>
                </a>
                <?php endif; ?>
                
                <?php if ($auth->checkPermission('companies', 'read')): ?>
                <a href="companies.php" style="text-decoration: none;">
                    <div style="border: 1px solid #dee2e6; padding: 12px; text-align: center; transition: all 0.3s; cursor: pointer; background: white;"
                         onmouseover="this.style.borderColor='#3498db';this.style.boxShadow='0 3px 10px rgba(0,0,0,0.08)'"
                         onmouseout="this.style.borderColor='#dee2e6';this.style.boxShadow='none'">
                        <div style="width: 40px; height: 40px; background: #3498db; border-radius: 0; display: flex; align-items: center; justify-content: center; margin: 0 auto 8px; color: white;">
                            <i class="fas fa-building" style="font-size: 16px;"></i>
                        </div>
                        <div style="font-weight: 600; color: #2c3e50; font-size: 13px; margin-bottom: 3px;">الشركات</div>
                        <div style="font-size: 11px; color: #7f8c8d;">الموردين والشركات</div>
                    </div>
                </a>
                <?php endif; ?>
                
             
            </div>
        </div>

        <!-- آخر النشاطات ومعلومات النظام -->
        <div style="display: flex; flex-wrap: wrap; gap: 20px; padding: 15px 20px;">
            <!-- آخر النشاطات -->
            <div style="flex: 1; min-width: 300px;">
                <h3 style="color: #2c3e50; margin-bottom: 15px; font-weight: 600; font-size: 16px; display: flex; align-items: center;">
                    <i class="fas fa-history" style="margin-left: 8px; color: #F19E2C;"></i>
                    آخر النشاطات
                </h3>
                
                <div style="background: white; border: 1px solid #dee2e6;">
                    <?php
                    try {
                        // جلب آخر النشاطات (الفواتير الأخيرة)
                        $recentInvoices = $db->query("
                            SELECT i.*, 
                                   c.name as customer_name, 
                                   u.username as created_by_name,
                                   cr.code as currency_code
                            FROM invoices i
                            LEFT JOIN customers c ON i.customer_id = c.id
                            LEFT JOIN users u ON i.created_by = u.id
                            LEFT JOIN currencies cr ON i.currency_id = cr.id
                            ORDER BY i.created_at DESC LIMIT 5
                        ")->fetchAll();
                        
                        if (count($recentInvoices) > 0):
                    ?>
                    <div style="max-height: 300px; overflow-y: auto;">
                        <?php foreach ($recentInvoices as $invoice):
                            $timeAgo = timeAgo(strtotime($invoice['created_at']));
                            $statusClass = [
                                'draft' => '#f39c12',
                                'confirmed' => '#2ecc71',
                                'cancelled' => '#e74c3c'
                            ][$invoice['status']] ?? '#95a5a6';
                        ?>
                        <div style="padding: 12px; border-bottom: 1px solid #f8f9fa; transition: background 0.3s;"
                             onmouseover="this.style.backgroundColor='#f8f9fa'"
                             onmouseout="this.style.backgroundColor='white'">
                            <div style="display: flex; align-items: center; gap: 10px;">
                                <div style="width: 36px; height: 36px; background: #e8f4fd; border-radius: 0; display: flex; align-items: center; justify-content: center; color: #3498db; flex-shrink: 0;">
                                    <i class="fas fa-file-invoice" style="font-size: 14px;"></i>
                                </div>
                                <div style="flex: 1; min-width: 0;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 4px;">
                                        <a href="invoices.php?selected_invoice=<?php echo $invoice['id']; ?>" 
                                           style="color: #3498db; text-decoration: none; font-weight: 600; font-size: 13px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                            <?php echo htmlspecialchars($invoice['invoice_number']); ?>
                                        </a>
                                        <span style="background: <?php echo $statusClass; ?>; color: white; padding: 2px 6px; font-size: 10px; border-radius: 0;">
                                            <?php echo $invoice['status'] == 'confirmed' ? 'مرحله' : 'غير مرحله'; ?>
                                        </span>
                                    </div>
                                    <div style="font-size: 12px; color: #2c3e50; margin-bottom: 3px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                        <?php echo htmlspecialchars($invoice['customer_name'] ?? 'بدون عميل'); ?>
                                    </div>
                                    <div style="display: flex; justify-content: space-between; align-items: center; font-size: 11px;">
                                        <span style="color: #7f8c8d;">
                                            <i class="fas fa-user" style="margin-left: 3px; font-size: 10px;"></i>
                                            <?php echo htmlspecialchars($invoice['created_by_name']); ?>
                                        </span>
                                        <span style="color: #7f8c8d;">
                                            <i class="fas fa-clock" style="margin-left: 3px; font-size: 10px;"></i>
                                            <?php echo $timeAgo; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php else: ?>
                    <div style="padding: 30px 20px; text-align: center; color: #7f8c8d;">
                        <i class="fas fa-file-invoice" style="font-size: 36px; margin-bottom: 10px; opacity: 0.3;"></i>
                        <div style="font-size: 13px;">لا توجد نشاطات حديثة</div>
                    </div>
                    <?php endif; ?>
                    <?php } catch (Exception $e) { ?>
                    <div style="padding: 30px 20px; text-align: center; color: #e74c3c;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 36px; margin-bottom: 10px;"></i>
                        <div style="font-size: 13px;">خطأ في جلب النشاطات</div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            
            <!-- معلومات النظام -->
            <div style="flex: 1; min-width: 300px;">
                <h3 style="color: #2c3e50; margin-bottom: 15px; font-weight: 600; font-size: 16px; display: flex; align-items: center;">
                    <i class="fas fa-info-circle" style="margin-left: 8px; color: #F19E2C;"></i>
                    معلومات النظام
                </h3>
                
                <div style="background: white; border: 1px solid #dee2e6; padding: 15px;">
                    <?php if ($auth->checkPermission('backup', 'create')): ?>
                    <button onclick="createBackup()" style="width: 100%; padding: 10px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 13px; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 8px; margin-bottom: 15px; transition: background 0.3s;"
                            onmouseover="this.style.background='#c0392b'"
                            onmouseout="this.style.background='#e74c3c'">
                        <i class="fas fa-database"></i>
                        إنشاء نسخة احتياطية كاملة
                    </button>
                    <?php endif; ?>
                    
                    <div style="border-top: 1px solid #f8f9fa; padding-top: 15px;">
                        <table style="width: 100%; border-collapse: collapse;">
                            <tr>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa;">
                                    <span style="color: #7f8c8d; font-size: 12px;">إصدار النظام:</span>
                                </td>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa; text-align: left;">
                                    <span style="font-weight: 600; color: #2c3e50; font-size: 12px;">v3.1.0</span>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa;">
                                    <span style="color: #7f8c8d; font-size: 12px;">آخر تحديث:</span>
                                </td>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa; text-align: left;">
                                    <span style="font-weight: 600; color: #2c3e50; font-size: 12px;"><?php echo date('Y-m-d'); ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa;">
                                    <span style="color: #7f8c8d; font-size: 12px;">قاعدة البيانات:</span>
                                </td>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa; text-align: left;">
                                    <span style="font-weight: 600; color: #27ae60; font-size: 12px;">نشطة</span>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa;">
                                    <span style="color: #7f8c8d; font-size: 12px;">آخر نسخة احتياطية:</span>
                                </td>
                                <td style="padding: 8px 0; border-bottom: 1px solid #f8f9fa; text-align: left;">
                                    <span style="font-weight: 600; color: #e74c3c; font-size: 12px;" id="lastBackup">غير متوفر</span>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 8px 0;">
                                    <span style="color: #7f8c8d; font-size: 12px;">حالة الخادم:</span>
                                </td>
                                <td style="padding: 8px 0; text-align: left;">
                                    <span style="font-weight: 600; color: #2ecc71; font-size: 12px;">جيدة</span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- التذييل -->
        <div style="padding: 12px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; font-size: 11px; color: #7f8c8d;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
                <div>
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي العملاء: <?php echo number_format($customersCount); ?> | الفواتير: <?php echo number_format($invoicesCount); ?> | الأصناف: <?php echo number_format($itemsCount); ?>
                </div>
                <div>
                    <i class="fas fa-calculator" style="margin-left: 5px;"></i>
                    إجمالي المبيعات: <?php echo number_format($totalSales, 2); ?> CNY
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// دالة حساب الوقت المنقضي
function timeAgo(timestamp) {
    const seconds = Math.floor((new Date() - timestamp * 1000) / 1000);
    
    let interval = seconds / 31536000;
    if (interval > 1) return Math.floor(interval) + " سنة";
    
    interval = seconds / 2592000;
    if (interval > 1) return Math.floor(interval) + " شهر";
    
    interval = seconds / 86400;
    if (interval > 1) return Math.floor(interval) + " يوم";
    
    interval = seconds / 3600;
    if (interval > 1) return Math.floor(interval) + " ساعة";
    
    interval = seconds / 60;
    if (interval > 1) return Math.floor(interval) + " دقيقة";
    
    return Math.floor(seconds) + " ثانية";
}

// دالة إنشاء النسخة الاحتياطية
function createBackup() {
    if (!confirm('هل تريد إنشاء نسخة احتياطية كاملة للنظام؟')) {
        return;
    }
    
    const loader = document.getElementById('backupLoader');
    const progress = document.getElementById('backupProgress');
    const message = document.getElementById('backupMessage');
    
    loader.style.display = 'flex';
    progress.style.width = '0%';
    message.textContent = 'جاري تصدير جداول قاعدة البيانات...';
    
    // محاكاة التقدم
    let progressValue = 0;
    const progressInterval = setInterval(() => {
        progressValue += 1;
        progress.style.width = progressValue + '%';
        
        if (progressValue <= 30) {
            message.textContent = 'جاري تصدير جداول قاعدة البيانات...';
        } else if (progressValue <= 60) {
            message.textContent = 'جاري ضغط مجلد الصور والملفات...';
        } else if (progressValue <= 90) {
            message.textContent = 'جاري إنشاء ملف النسخة الاحتياطية...';
        }
    }, 50);
    
    // طلب AJAX لإنشاء النسخة الاحتياطية
    fetch('create_backup.php')
        .then(response => {
            clearInterval(progressInterval);
            progress.style.width = '100%';
            
            if (!response.ok) {
                return response.text().then(text => {
                    throw new Error(text || 'فشل في إنشاء النسخة الاحتياطية');
                });
            }
            
            message.textContent = 'اكتملت العملية! جاري تحميل الملف...';
            return response.blob();
        })
        .then(blob => {
            if (!blob || blob.size === 0) {
                throw new Error('الملف فارغ أو تالف');
            }
            
            // إنشاء رابط للتحميل
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'backup_gts_' + new Date().toISOString().slice(0, 10) + '.zip';
            document.body.appendChild(a);
            a.click();
            
            // تنظيف
            setTimeout(() => {
                window.URL.revokeObjectURL(url);
                document.body.removeChild(a);
                loader.style.display = 'none';
                
                // تحديث تاريخ آخر نسخة احتياطية
                document.getElementById('lastBackup').textContent = new Date().toLocaleDateString('ar-EG');
                document.getElementById('lastBackup').style.color = '#27ae60';
                
                // عرض رسالة نجاح
                alert('تم إنشاء النسخة الاحتياطية بنجاح وبدأ تحميل الملف!');
            }, 1000);
        })
        .catch(error => {
            clearInterval(progressInterval);
            loader.style.display = 'none';
            
            // عرض رسالة الخطأ
            const errorMessage = error.message.includes('فشل في الاتصال') 
                ? 'لا يمكن الاتصال بالخادم. تحقق من اتصال الشبكة.'
                : error.message;
                
            alert('حدث خطأ أثناء إنشاء النسخة الاحتياطية:\n' + errorMessage);
            
            // اقتراح فتح صفحة التشخيص
            if (confirm('هل تريد فتح صفحة التشخيص لحل المشكلة؟')) {
                window.open('backup_debug.php', '_blank');
            }
        });
}

// جلب تاريخ آخر نسخة احتياطية عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
    fetch('check_last_backup.php')
        .then(response => response.json())
        .then(data => {
            if (data.lastBackup) {
                document.getElementById('lastBackup').textContent = data.lastBackup;
                document.getElementById('lastBackup').style.color = '#27ae60';
            }
        })
        .catch(error => {
            console.error('Error fetching last backup:', error);
        });
});
</script>

<?php
// دالة مساعدة لعرض الوقت المنقضي
function timeAgo($timestamp) {
    $currentTime = time();
    $timeDifference = $currentTime - $timestamp;
    
    if ($timeDifference < 60) {
        return 'منذ لحظات';
    } elseif ($timeDifference < 3600) {
        $minutes = floor($timeDifference / 60);
        return 'منذ ' . $minutes . ' دقيقة';
    } elseif ($timeDifference < 86400) {
        $hours = floor($timeDifference / 3600);
        return 'منذ ' . $hours . ' ساعة';
    } elseif ($timeDifference < 2592000) {
        $days = floor($timeDifference / 86400);
        return 'منذ ' . $days . ' يوم';
    } elseif ($timeDifference < 31536000) {
        $months = floor($timeDifference / 2592000);
        return 'منذ ' . $months . ' شهر';
    } else {
        $years = floor($timeDifference / 31536000);
        return 'منذ ' . $years . ' سنة';
    }
}

include 'views/layout/footer.php';
?>