<?php
// account_statement.php
session_start();

// --- إعدادات الاتصال بقاعدة البيانات ---
$DB_HOST = '127.0.0.1';
$DB_USER = 'goldhldz_aknan';
$DB_PASS = 'W2%#l2r*)oW_';
$DB_NAME = 'goldhldz_onlinedesign';

$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_errno) {
    die("فشل الاتصال بقاعدة البيانات: " . $mysqli->connect_error);
}
$mysqli->set_charset('utf8mb4');

// --- تعريف أنواع الحسابات المتاحة ---
$account_types = [
    'customer' => ['name' => 'عميل', 'table' => 'customers', 'balance_field' => 'current_balance'],
    'company' => ['name' => 'شركة', 'table' => 'companies', 'balance_field' => 'current_balance'],
    'cash' => ['name' => 'صندوق', 'table' => 'cash_boxes', 'balance_field' => 'current_balance'],
    'bank' => ['name' => 'بنك', 'table' => 'bank_accounts', 'balance_field' => 'current_balance']
];

// --- معالجة الطلب ---
$type = $_GET['type'] ?? 'customer';
$id = intval($_GET['id'] ?? 0);
$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? date('Y-m-d');
$action = $_GET['action'] ?? 'view';
$currency_id = $_GET['currency_id'] ?? null; // العملة المختارة للعرض

// التحقق من صحة نوع الحساب
if (!isset($account_types[$type])) {
    $type = 'customer';
}

// --- جلب قائمة الحسابات المتاحة ---
function get_accounts_list($mysqli, $type, $account_types) {
    if (!isset($account_types[$type])) return [];
    
    $table = $account_types[$type]['table'];
    $query = "SELECT id, name";
    
    // إضافة حقول إضافية حسب نوع الحساب
    if ($type === 'bank') {
        $query .= ", bank_name, account_number";
    } elseif ($type === 'cash') {
        $query .= ", description";
    } else {
        $query .= ", phone, address";
    }
    
    $query .= " FROM $table WHERE is_active = 1 ORDER BY name";
    $result = $mysqli->query($query);
    
    $accounts = [];
    while ($row = $result->fetch_assoc()) {
        $accounts[] = $row;
    }
    
    return $accounts;
}

// --- جلب العملات النشطة ---
function get_currencies($mysqli) {
    $query = "SELECT id, name, code, exchange_rate, is_default FROM currencies WHERE is_active = 1 ORDER BY is_default DESC, name";
    $result = $mysqli->query($query);
    
    $currencies = [];
    while ($row = $result->fetch_assoc()) {
        $currencies[] = $row;
    }
    
    return $currencies;
}

// --- جلب سعر الصرف ---
function get_exchange_rate($mysqli, $currency_id) {
    $stmt = $mysqli->prepare("SELECT exchange_rate, code FROM currencies WHERE id = ?");
    $stmt->bind_param('i', $currency_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return $result ? $result : ['exchange_rate' => 1, 'code' => 'USD'];
}

// --- جلب سعر صرف الفاتورة ---
function get_invoice_exchange_rate($mysqli, $invoice_id, $currency_id) {
    $stmt = $mysqli->prepare("
        SELECT exchange_rate 
        FROM invoice_exchange_rates 
        WHERE invoice_id = ? AND currency_id = ?
    ");
    $stmt->bind_param('ii', $invoice_id, $currency_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return $result ? $result['exchange_rate'] : null;
}

// --- جلب سعر صرف السند ---
function get_voucher_exchange_rate($mysqli, $voucher_id, $currency_id) {
    $stmt = $mysqli->prepare("
        SELECT exchange_rate 
        FROM voucher_exchange_rates 
        WHERE voucher_id = ? AND currency_id = ?
    ");
    $stmt->bind_param('ii', $voucher_id, $currency_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return $result ? $result['exchange_rate'] : null;
}

// --- جلب العملة الافتراضية ---
function get_default_currency($mysqli) {
    $query = "SELECT id, code, name, exchange_rate FROM currencies WHERE is_default = 1";
    $result = $mysqli->query($query);
    return $result->fetch_assoc();
}

// --- إذا كان هناك طلب لعرض كشف حساب ---
if ($action === 'statement' && $id > 0 && isset($account_types[$type])) {
    // جلب العملات النشطة
    $currencies = get_currencies($mysqli);
    $default_currency = get_default_currency($mysqli);
    
    // تحديد العملة للعرض
    $selected_currency = null;
    $selected_currency_code = $default_currency['code'];
    $selected_currency_name = $default_currency['name'];
    $exchange_rate = 1; // بالنسبة للعملة الافتراضية
    
    if ($currency_id) {
        foreach ($currencies as $currency) {
            if ($currency['id'] == $currency_id) {
                $selected_currency = $currency;
                $selected_currency_code = $currency['code'];
                $selected_currency_name = $currency['name'];
                $exchange_rate = $currency['exchange_rate'];
                break;
            }
        }
    }
    
    // جلب بيانات الكيان
    $table = $account_types[$type]['table'];
    $stmt = $mysqli->prepare("SELECT id, name FROM $table WHERE id = ?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $entity = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if (!$entity) {
        die('<div class="alert alert-danger">لم يتم العثور على الحساب المطلوب</div>');
    }
    
    // حساب الرصيد الافتتاحي (بالعملة المحلية)
 
$opening_stmt = $mysqli->prepare("
    SELECT IFNULL(SUM(t.debit_amount - t.credit_amount),0) AS opening_balance
    FROM transactions t
    LEFT JOIN invoices i 
        ON t.related_invoice_id = i.id
    WHERE t.account_type = ?
      AND t.account_id = ?
      AND t.is_reversed = 0
      AND DATE(t.date) < ?
      AND (
            t.related_invoice_id IS NULL
            OR i.status = 'confirmed'
          )
");
$opening_stmt->bind_param('sis', $type, $id, $from);
$opening_stmt->execute();
$opening_res = $opening_stmt->get_result()->fetch_assoc();
$opening_balance_local = (float)$opening_res['opening_balance'];
$opening_stmt->close();

    
    // تحويل الرصيد الافتتاحي إلى العملة المختارة
    $opening_balance = $opening_balance_local * $exchange_rate;
    
    // جلب الحركات خلال الفترة
   
$tx_stmt = $mysqli->prepare("
    SELECT 
        t.id,
        t.date,
        t.description,
        t.debit_amount,
        t.credit_amount,
        t.voucher_type,
        t.related_voucher_id,
        t.related_invoice_id,
        t.created_at,
        t.cash_box_id,
        t.bank_account_id
    FROM transactions t
    LEFT JOIN invoices i 
        ON t.related_invoice_id = i.id
    WHERE t.account_type = ?
      AND t.account_id = ?
      AND t.is_reversed = 0
      AND DATE(t.date) BETWEEN ? AND ?
      AND (
            t.related_invoice_id IS NULL
            OR i.status = 'confirmed'
          )
    ORDER BY t.date ASC, t.id ASC
");
$tx_stmt->bind_param('siss', $type, $id, $from, $to);
$tx_stmt->execute();
$tx_result = $tx_stmt->get_result();
    
    // حساب الرصيد التراكمي
    $running_local = $opening_balance_local;
    $running = $opening_balance;
    $transactions = [];
    $total_debit_local = 0;
    $total_credit_local = 0;
    $total_debit = 0;
    $total_credit = 0;
    
    while($row = $tx_result->fetch_assoc()) {
        $debit_local = (float)$row['debit_amount'];
        $credit_local = (float)$row['credit_amount'];
        
        $running_local += ($debit_local - $credit_local);
        
        // تحديد سعر الصرف المناسب لكل حركة
        $tx_exchange_rate = $exchange_rate; // الافتراضي: سعر الصرف الرئيسي
        
        // إذا كانت الحركة مرتبطة بفاتورة
        if ($row['related_invoice_id']) {
            $invoice_rate = get_invoice_exchange_rate($mysqli, $row['related_invoice_id'], $currency_id ?: $default_currency['id']);
            if ($invoice_rate !== null) {
                $tx_exchange_rate = $invoice_rate;
            }
        }
        // إذا كانت الحركة مرتبطة بسند
        elseif ($row['related_voucher_id']) {
            $voucher_rate = get_voucher_exchange_rate($mysqli, $row['related_voucher_id'], $currency_id ?: $default_currency['id']);
            if ($voucher_rate !== null) {
                $tx_exchange_rate = $voucher_rate;
            }
        }
        
        // تحويل المبالغ إلى العملة المختارة
        $debit = $debit_local * $tx_exchange_rate;
        $credit = $credit_local * $tx_exchange_rate;
        $running = $running_local * $exchange_rate; // للرصيد التراكمي نستخدم السعر الرئيسي
        
        $row['debit_amount_local'] = $debit_local;
        $row['credit_amount_local'] = $credit_local;
        $row['debit_amount_foreign'] = $debit;
        $row['credit_amount_foreign'] = $credit;
        $row['exchange_rate'] = $tx_exchange_rate;
        $row['running_balance_local'] = $running_local;
        $row['running_balance'] = $running;
        $row['formatted_date'] = date('d/m/Y', strtotime($row['date']));
        $transactions[] = $row;
        
        $total_debit_local += $debit_local;
        $total_credit_local += $credit_local;
        $total_debit += $debit;
        $total_credit += $credit;
    }
    
    $final_balance_local = $running_local;
    $final_balance = $running;
}
?>

<?php
include 'header.php';
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف الحساب - نظام إدارة الحسابات</title>
    <link rel="stylesheet" href="fonts/Almarai-local/fonts/fonts.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <script src="jquery-3.6.0.min.js"></script>
     <link href="bootstrap.min.css" rel="stylesheet">
   <link href="select2.min.css" rel="stylesheet" />
   <script src="bootstrap.bundle.min.js"></script>
   <script src="select2.min.js"></script>
    <style>
         .select2-container--default .select2-selection--single {
   border: 2px solid #e2e8f0 !important;
   border-radius: 6px !important;
   height: auto !important;
   padding: 3px 15px !important;
   font-family: 'Almarai', sans-serif !important;
   font-size: clamp(0.9rem, 2vw, 1rem) !important;
   background-color: transparent !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
   color: var(--text-color) !important;
   line-height: 1.5 !important;
   padding: 0 !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
   height: 100% !important;
   right: 10px !important;
   width: 20px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
   border-color: var(--primary-color) transparent transparent transparent !important;
   border-width: 6px 6px 0 6px !important;
}


.select2-container--default .select2-results__option[aria-selected=true] {
   background-color: #F19E2C !important;
   color: var(--primary-color) !important;
}

.select2-container--default .select2-dropdown {
   border: 2px solid #e2e8f0 !important;
   border-radius: 6px !important;
   box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1) !important;
}

/* إزالة تأثير التركيز */
.select2-container--default .select2-selection--single:focus {
   outline: none !important;
   border-color: var(--primary-color) !important;
   box-shadow: 0 0 8px rgba(33, 74, 154, 0.1) !important;
}

/* تنسيق العنصر عند الفتح */
.select2-container--open .select2-selection--single {
   border-color: var(--primary-color) !important;
}

/* تعديلات للوضع RTL */
.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__arrow {
   left: 10px !important;
   right: auto !important;
}

/* تعديلات للوضع RTL */
.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__arrow {
  left: 20px !important;
  right: auto !important;
}
/* منع تكبير ارتفاع الصندوق عند الفتح */
.select2-container--open .select2-dropdown--below {
  margin-top: 2px !important;
}
/* السهم */
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 100% !important;
    width: 25px !important;
    position: absolute !important;
    top: 50% !important;
    transform: translateY(-50%) !important;
}

/* شكل السهم */
.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-style: solid !important;
    border-width: 6px 6px 0 6px !important;
    border-color: #214A9A transparent transparent transparent !important;
    display: block !important;
    width: 0 !important;
    height: 0 !important;
    margin: auto !important;
}
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Almarai', sans-serif;
        }
        
        
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        
        
        /* Card Styling */
        .card {
           border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
             border-radius: 0;
              margin: 5px auto;
               max-width: 1200px;
               padding: 8px;  
        }
        
        .card-header {
           background: #2c3e50;
            color: white; 
            padding: 15px 20px;
             border-bottom: 3px solid #1a252f; 
             margin-bottom: 0;
             
    position: sticky;
    top: 0;
    z-index: 1100;
        }
        
        .card-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h2 {
            margin: 0;
            font-weight: 600;
            font-size: 18px;
            display: flex;
            align-items: center;
        }
        
        .card-header h2 i {
            margin-left: 8px;
        }
        
        .card-header .badge {
            background: #F19E2C;
            padding: 4px 8px;
            border-radius: 0;
            font-size: 12px;
            opacity: 0.8;
        }
        
        .card-body {
            padding: 0;
        }
        
        /* Form Styling */
        .form-section {
            margin-bottom: 30px;
            padding: 25px;
        }
        
        .form-title {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #ecf0f1;
        }
        
        .form-title h3 {
            margin: 0;
            font-size: 16px;
            color: #2c3e50;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .form-title h3 i {
            margin-left: 8px;
            color: #F19E2C;
        }
        
        .form-title-bar {
            width: 4px;
            height: 20px;
            background: #F19E2C;
            margin-left: 10px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: 500;
            font-size: 14px;
        }
        
        .form-label .required {
            color: #e74c3c;
        }
        
        .form-control {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #bdc3c7;
            border-radius: 0;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            border-color: #F19E2C;
            outline: none;
            box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
        }
        
        .form-small {
            color: #95a5a6;
            font-size: 12px;
            display: block;
            margin-top: 5px;
        }
        
        .form-small i {
            margin-left: 4px;
        }
        
        /* Type Selector */
        .type-selector {
            display: flex;
            gap: 10px;
            margin-bottom: 25px;
            flex-wrap: wrap;
        }
        
        .type-btn {
            padding: 12px 25px;
            background: white;
            border: 2px solid #ddd;
            border-radius: 0;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .type-btn:hover {
            border-color: #F19E2C;
            color: #F19E2C;
        }
        
        .type-btn.active {
            background: #F19E2C;
            color: white;
            border-color: #F19E2C;
        }
        
        /* Accounts Grid */
        .accounts-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        
        .account-card {
            background: white;
            border-radius: 0;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            transition: all 0.3s;
            border-left: 4px solid #F19E2C;
            cursor: pointer;
        }
        
        .account-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.1);
            border-left-color: #2ecc71;
        }
        
        .account-type {
            display: inline-block;
            padding: 4px 12px;
            background: #ecf0f1;
            color: #2c3e50;
            border-radius: 0;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .account-name {
            font-size: 18px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 8px;
        }
        
        .account-details {
            color: #666;
            font-size: 14px;
            line-height: 1.5;
        }
        
        /* Statement Header */
        .statement-header {
            padding: 20px;
            background: #f8f9fa;
            border-bottom: 1px solid #ecf0f1;
            margin-bottom: 0;
        }
        
        .statement-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .entity-info h2 {
            color: #2c3e50;
            margin-bottom: 5px;
            font-size: 20px;
        }
        
        .entity-badge {
            display: inline-block;
            padding: 5px 12px;
            background: #F19E2C;
            color: white;
            border-radius: 0;
            font-size: 14px;
            font-weight: 600;
        }
        
        .period-info {
            background: white;
            padding: 12px 20px;
            border-radius: 0;
            border: 1px solid #e9ecef;
            min-width: 250px;
        }
        
        /* Balance Summary */
        .balance-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px;
        }
        
        .balance-card {
            background: white;
            padding: 20px;
            border-radius: 0;
            text-align: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            border-top: 4px solid;
        }
        
        .balance-card.opening {
            border-top-color: #f39c12;
        }
        
        .balance-card.debit {
            border-top-color: #2ecc71;
        }
        
        .balance-card.credit {
            border-top-color: #e74c3c;
        }
        
        .balance-card.final {
            border-top-color: #3498db;
        }
        
        .balance-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 8px;
        }
        
        .balance-value {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .balance-value.positive {
            color: #2ecc71;
        }
        
        .balance-value.negative {
            color: #e74c3c;
        }
        
        .balance-rate {
            color: #95a5a6;
            font-size: 12px;
        }
        
        /* Table */
        .table-container {
            margin: 10px;
            overflow-x: auto;
            border-radius: 0;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .statement-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        
        .statement-table thead {
            background: #2c3e50;
            color: white;
            font-size: 14px;
        }
        
        .statement-table th {
            padding: 5px;
            text-align: center;
            font-weight: 600;
            white-space: nowrap;
            border: none;
        }
        
        .statement-table tbody tr {
            border-bottom: 1px solid #ecf0f1;
                transition: background-color 0.2s ease;
        }
        
        .statement-table tbody tr:hover {
            background: #f8f9fa;
        }
        
        .statement-table td {
            padding: 8px 12px;
            text-align: center;
            vertical-align: middle;
            border: none;
        }
        
        .statement-table .debit {
            color: #2ecc71;
            font-weight: 600;
        }
        
        .statement-table .credit {
            color: #e74c3c;
            font-weight: 600;
        }
        
        .voucher-badge {
            display: inline-block;
            padding: 3px 8px;
            background: #e8f4fc;
            color: #3498db;
            border-radius: 0;
            font-size: 12px;
            font-weight: 600;
        }
        
        /* Buttons */
        .action-buttons {
            background: #f8f9fa;
            padding: 15px 25px;
            border-top: 1px solid #ecf0f1;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .button-group {
            display: flex;
            gap: 10px;
        }
        
        .btn {
            padding: 8px 20px;
            border: none;
            border-radius: 0;
            font-size: 14px;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            transition: background-color  0.3s;
            text-decoration: none;
        }
        
        .btn i {
            margin-left: 8px;
        }
        
        .btn-secondary {
            background: #95a5a6;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #7f8c8d;
        }
        
        .btn-primary {
            background: #F19E2C;
            color: white;
        }
        
        .btn-primary:hover {
            background: #e18E1b;
        }
        
        .btn-success {
            background: #2ecc71;
            color: white;
        }
        
        .btn-success:hover {
            background: #27ae60;
        }
        
        .btn-outline {
            background: transparent;
            border: 1px solid #3498db;
            color: #3498db;
        }
        
        .btn-outline:hover {
            background: #3498db;
            color: white;
        }
        
        /* Currency Selector */
        .currency-selector {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 0;
            border: 1px solid #e9ecef;
        }
        
        .currency-display {
            background: #e8f4fc;
            padding: 15px;
            border-radius: 0;
            margin: 20px;
            text-align: center;
            border: 1px solid #b3d9ff;
        }
        
        .currency-badge {
            background-color: #17a2b8;
            color: white;
            padding: 4px 8px;
            border-radius: 0;
            font-size: 12px;
            margin-left: 5px;
        }
        
        /* No Data */
        .no-data {
            text-align: center;
            padding: 40px 20px;
            color: #666;
        }
        
        .no-data i {
            font-size: 50px;
            color: #ddd;
            margin-bottom: 15px;
        }
        
        /* Alert */
        .alert {
            margin: 0;
            border-radius: 0;
            border: none;
            border-bottom: 1px solid #e74c3c;
            background: #ffe6e6;
            padding: 12px 20px;
            display: flex;
            align-items: center;
        }
        
        .alert i {
            margin-left: 10px;
            color: #e74c3c;
        }
        
        /* Footer Info */
        .footer-info {
            font-size: 12px;
            color: #7f8c8d;
            display: flex;
            align-items: center;
        }
        
        .footer-info i {
            margin-left: 5px;
        }
        
        /* Loader */
        #loadingOverlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255,255,255,0.9);
            z-index: 9999;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }
        
        .loader {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 20px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .balance-summary {
                grid-template-columns: 1fr;
            }
            
            .statement-header-content {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .action-buttons {
                flex-direction: column;
                gap: 15px;
                align-items: stretch;
            }
            
            .button-group {
                flex-wrap: wrap;
                justify-content: center;
            }
            
            .accounts-grid {
                grid-template-columns: 1fr;
            }
            
            .period-info {
                min-width: auto;
                width: 100%;
            }
        }
        
        /* Print Styles */
        .print-only {
            display: none;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            .print-only {
                display: block;
            }
            
            body {
                background: white;
                padding: 0;
            }
            
            .card {
                box-shadow: none;
                border: 1px solid #ddd;
            }
            
            .statement-table {
                border: 1px solid #ddd;
            }
            
            .statement-table th {
                background: #f0f0f0 !important;
                color: black !important;
                -webkit-print-color-adjust: exact;
            }
        }
    </style>
</head>
<body>
    <!-- Loader Overlay -->
    <div id="loadingOverlay" style="display: none;">
        <div class="loader"></div>
        <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري تحميل البيانات...</div>
        <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
    </div>


        <!-- Main Card -->
        <div class="card">
            <div class="card-header">
                <div class="card-header-content">
                    <h2>
                        <i class="fas fa-file-invoice-dollar"></i>
                        كشف الحسابات المالية
                    </h2>
                    <div>
                        <span class="badge">نظام التقارير</span>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php if (!empty($error) && isset($error)): ?>
                <div class="alert">
                    <i class="fas fa-exclamation-circle"></i>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
                <?php endif; ?>

                <!-- Account Type Selection -->
                <div class="form-section no-print">
                    <div class="form-title">
                        <div class="form-title-bar"></div>
                        <h3>
                            <i class="fas fa-filter"></i>
                            اختيار نوع الحساب
                        </h3>
                    </div>
                    
                    <div class="type-selector">
                        <?php foreach ($account_types as $key => $account_type): ?>
                            <button class="type-btn <?= ($type === $key) ? 'active' : '' ?>" 
                                    onclick="selectType('<?= $key ?>')">
                                <i class="fas fa-<?= 
                                    $key === 'customer' ? 'user' : 
                                    ($key === 'company' ? 'building' : 
                                    ($key === 'cash' ? 'money-bill-wave' : 'university')) 
                                ?>"></i>
                                <?= $account_type['name'] ?>
                            </button>
                        <?php endforeach; ?>
                    </div>
                    
                    <form method="get" action="" id="statementForm" onsubmit="showLoader()">
                        <input type="hidden" name="type" id="accountType" value="<?= $type ?>">
                        <input type="hidden" name="action" id="action" value="view">
                        
                        <div class="form-group">
                            <label class="form-label" for="accountSelect">
                                <span class="required">*</span> اختر الحساب
                            </label>
                            <select class="form-control select2" id="accountSelect" name="id" required onchange="selectAccount(this.value)">
                                <option value="">-- اختر حساب --</option>
                                <?php
                                $accounts = get_accounts_list($mysqli, $type, $account_types);
                                foreach ($accounts as $account):
                                ?>
                                    <option value="<?= $account['id'] ?>" <?= ($id == $account['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($account['name']) ?>
                                        <?php if ($type === 'bank' && isset($account['bank_name'])): ?>
                                            (<?= htmlspecialchars($account['bank_name']) ?> - <?= htmlspecialchars($account['account_number']) ?>)
                                        <?php elseif ($type === 'cash' && isset($account['description'])): ?>
                                            (<?= htmlspecialchars($account['description']) ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small class="form-small">
                                <i class="fas fa-info-circle"></i> اختر الحساب الذي ترغب في عرض كشفه
                            </small>
                        </div>
                        
                        <?php if ($id > 0): ?>
                        <!-- Currency Selection -->
                        <div class="currency-selector">
                            <div class="form-group">
                                <label class="form-label" for="currencySelect">اختر العملة للعرض</label>
                                <select class="form-control" id="currencySelect" name="currency_id">
                                    <option value="">العملة المحلية (الافتراضية)</option>
                                    <?php 
                                    $currencies = get_currencies($mysqli);
                                    foreach ($currencies as $currency): 
                                        if (!$currency['is_default']): // لا نعرض العملة الافتراضية
                                    ?>
                                        <option value="<?= $currency['id'] ?>" <?= ($currency_id == $currency['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($currency['name']) ?> (<?= htmlspecialchars($currency['code']) ?>)
                                        </option>
                                    <?php 
                                        endif;
                                    endforeach; 
                                    ?>
                                </select>
                                <small class="form-small">
                                    <i class="fas fa-info-circle"></i> اختر عملة أجنبية لعرض الكشف بها
                                </small>
                            </div>
                        </div>
                        
                        <!-- Date Range -->
                        <div class="form-group">
                            <label class="form-label">الفترة الزمنية</label>
                            <div class="form-row">
                                <div class="form-group">
                                    <label style="display: block; margin-bottom: 5px; font-size: 14px;">من تاريخ</label>
                                    <input type="date" class="form-control" name="from" value="<?= $from ?>" required>
                                </div>
                                <div class="form-group">
                                    <label style="display: block; margin-bottom: 5px; font-size: 14px;">إلى تاريخ</label>
                                    <input type="date" class="form-control" name="to" value="<?= $to ?>" required>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="action-buttons no-print">
                            <div class="footer-info">
                                <i class="fas fa-exclamation-triangle"></i>
                                الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                            </div>
                            
                            <div class="button-group">
                                <button type="submit" class="btn btn-primary" name="action" value="statement">
                                    <i class="fas fa-search"></i> عرض كشف الحساب
                                </button>
                                <a href="accounts.php" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- Accounts List -->
                <?php if ($action === 'view' && $type && empty($id)): ?>
                    <div class="form-section no-print">
                        <div class="form-title">
                            <div class="form-title-bar"></div>
                            <h3>
                                <i class="fas fa-list"></i>
                                الحسابات المتاحة (<?= $account_types[$type]['name'] ?>)
                            </h3>
                        </div>
                        
                        <?php if (count($accounts) > 0): ?>
                            <div class="accounts-grid">
                                <?php foreach ($accounts as $account): ?>
                                    <div class="account-card" onclick="selectAccount(<?= $account['id'] ?>)">
                                        <div class="account-type"><?= $account_types[$type]['name'] ?></div>
                                        <div class="account-name"><?= htmlspecialchars($account['name']) ?></div>
                                        <div class="account-details">
                                            <?php if ($type === 'bank'): ?>
                                                <div><i class="fas fa-university"></i> <?= htmlspecialchars($account['bank_name']) ?></div>
                                                <div><i class="fas fa-hashtag"></i> <?= htmlspecialchars($account['account_number']) ?></div>
                                            <?php elseif ($type === 'cash'): ?>
                                                <div><i class="fas fa-info-circle"></i> <?= htmlspecialchars($account['description'] ?? '') ?></div>
                                            <?php else: ?>
                                                <div><i class="fas fa-phone"></i> <?= htmlspecialchars($account['phone'] ?? '') ?></div>
                                                <div><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($account['address'] ?? '') ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="no-data">
                                <i class="fas fa-inbox"></i>
                                <h3>لا توجد حسابات</h3>
                                <p>لا توجد حسابات من نوع <?= $account_types[$type]['name'] ?> في النظام</p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <!-- Statement Display -->
                <?php if ($action === 'statement' && $id > 0): ?>
                    <div class="statement-header">
                        <div class="statement-header-content">
                            <div class="entity-info">
                                <h2><?= htmlspecialchars($entity['name']) ?></h2>
                                <span class="entity-badge"><?= $account_types[$type]['name'] ?></span>
                                <?php if ($currency_id): ?>
                                    <span class="currency-badge"><?= htmlspecialchars($selected_currency_code) ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="period-info">
                                <div><strong>الفترة:</strong> <?= date('d/m/Y', strtotime($from)) ?> - <?= date('d/m/Y', strtotime($to)) ?></div>
                                <div><strong>تاريخ الطباعة:</strong> <?= date('d/m/Y H:i') ?></div>
                                <?php if ($currency_id): ?>
                                    <div><strong>العملة:</strong> <?= htmlspecialchars($selected_currency_name) ?> (<?= htmlspecialchars($selected_currency_code) ?>)</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Currency Display -->
                    <?php if ($currency_id): ?>
                    <div class="currency-display">
                        <h4 style="margin: 0; color: #0c5460;">
                            <i class="fas fa-exchange-alt"></i> 
                            الكشف بالعملة: <?= htmlspecialchars($selected_currency_name) ?> (<?= htmlspecialchars($selected_currency_code) ?>)
                        </h4>
                        <p style="margin: 5px 0; color: #666;">
                            سعر الصرف الرئيسي: 1 <?= $default_currency['code'] ?> = <?= number_format($exchange_rate, 6) ?> <?= $selected_currency_code ?>
                        </p>
                    </div>
                    <?php endif; ?>

                    <!-- Balance Summary -->
                    <div class="balance-summary">
                        <div class="balance-card opening">
                            <div class="balance-label">الرصيد السابق</div>
                            <div class="balance-value <?= ($opening_balance >= 0) ? 'positive' : 'negative' ?>">
                                <?= number_format($opening_balance, 2) ?> 
                                <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?>
                            </div>
                            <?php if ($currency_id): ?>
                                <div class="balance-rate">
                                    <?= number_format($opening_balance_local, 2) ?> <?= $default_currency['code'] ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="balance-card debit">
                            <div class="balance-label">إجمالي المدين ’’عليه‘‘</div>
                            <div class="balance-value positive">
                                <?= number_format($total_debit, 2) ?> 
                                <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?>
                            </div>
                            <?php if ($currency_id): ?>
                                <div class="balance-rate">
                                    <?= number_format($total_debit_local, 2) ?> <?= $default_currency['code'] ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="balance-card credit">
                            <div class="balance-label">إجمالي الدائن’’له‘‘</div>
                            <div class="balance-value negative">
                                <?= number_format($total_credit, 2) ?> 
                                <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?>
                            </div>
                            <?php if ($currency_id): ?>
                                <div class="balance-rate">
                                    <?= number_format($total_credit_local, 2) ?> <?= $default_currency['code'] ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="balance-card final">
                            <div class="balance-label">الرصيد النهائي</div>
                            <div class="balance-value <?= ($final_balance >= 0) ? 'positive' : 'negative' ?>">
                                <?= number_format($final_balance, 2) ?> 
                                <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?>
                            </div>
                            <?php if ($currency_id): ?>
                                <div class="balance-rate">
                                    <?= number_format($final_balance_local, 2) ?> <?= $default_currency['code'] ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Transactions Table -->
                    <div class="table-container">
                        <table class="statement-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>البيان</th>
                                    <th>نوع السند</th>
                                    <th>مدين’’عليه‘‘ <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?></th>
                                    <th>دائن ’’له‘‘ <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?></th>
                                    <th>الرصيد التراكمي <?= $currency_id ? htmlspecialchars($selected_currency_code) : '' ?></th>
                                    <?php if ($currency_id): ?>
                                        <th>سعر الصرف</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Opening Balance Row -->
                                <tr style="background: #f9f9f9; font-size: 13px;">
                                    <td>#</td>
                                    <td><?= date('d/m/Y', strtotime($from)) ?></td>
                                    <td style="text-align: right; font-weight: 600;">الرصيد السابق</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td style="font-weight: 600 ; <?= ($opening_balance >= 0) ? 'color: #2ecc71;' : 'color: #e74c3c;' ?>">
                                        <?= number_format($opening_balance, 2) ?>
                                    </td>
                                    <?php if ($currency_id): ?>
                                        <td><?= number_format($exchange_rate, 6) ?></td>
                                    <?php endif; ?>
                                </tr>
                                
                                <?php if (count($transactions) > 0): ?>
                                    <?php $counter = 1; ?>
                                    <?php foreach ($transactions as $tx): ?>
                                        <tr>
                                            <td style="font-size: 12px;"><?= $counter++ ?></td>
                                            <td style="font-size: 12px;"><?= $tx['formatted_date'] ?></td>
                                            <td style="text-align: right; font-size: 12px;"><?= htmlspecialchars($tx['description']) ?></td>
                                            <td>
                                                <?php if ($tx['voucher_type']): ?>
                                                    <span class="voucher-badge">
                                                        <?= ($tx['voucher_type'] == 'receipt') ? 'سند قبض' : 'سند صرف' ?>
                                                    </span>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td class="debit" style="font-size: 13px;">
                                                <?= ($tx['debit_amount_foreign'] > 0) ? number_format($tx['debit_amount_foreign'], 2) : '' ?>
                                            </td>
                                            <td class="credit" style="font-size: 13px;">
                                                <?= ($tx['credit_amount_foreign'] > 0) ? number_format($tx['credit_amount_foreign'], 2) : '' ?>
                                            </td>
                                            <td style="font-weight: 600; font-size: 13px; <?= ($tx['running_balance'] >= 0) ? 'color: #2ecc71;' : 'color: #e74c3c;' ?>">
                                                <?= number_format($tx['running_balance'], 2) ?>
                                            </td>
                                            <?php if ($currency_id): ?>
                                                <td style="font-size: 12px; color: #666;">
                                                    <?= number_format($tx['exchange_rate'], 6) ?>
                                                    <?php if ($tx['related_invoice_id']): ?>
                                                        <br><small>(فاتورة)</small>
                                                    <?php elseif ($tx['related_voucher_id']): ?>
                                                        <br><small>(سند)</small>
                                                    <?php else: ?>
                                                        <br><small>(رئيسي)</small>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="<?= $currency_id ? '8' : '7' ?>" style="text-align: center; padding: 40px; color: #666;">
                                            <i class="fas fa-inbox" style="font-size: 40px; margin-bottom: 15px; display: block; color: #ddd;"></i>
                                            لا توجد حركات في هذه الفترة
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                
                                <!-- Final Balance Row -->
                                <tr style="background: #f0f8ff; font-weight: bold; font-size: 13px;">
                                    <td colspan="<?= $currency_id ? '5' : '4' ?>">الرصيد النهائي</td>
                                    <td><?= number_format($total_debit, 2) ?></td>
                                    <td><?= number_format($total_credit, 2) ?></td>
                                    <td style="<?= ($final_balance >= 0) ? 'color: #2ecc71;' : 'color: #e74c3c;' ?>">
                                        <?= number_format($final_balance, 2) ?>
                                    </td>
                                    <?php if ($currency_id): ?>
                                        <td>-</td>
                                    <?php endif; ?>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Notes -->
                    <?php if ($currency_id): ?>
                    <div class="form-section" style="margin: 20px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                        <div style="display: flex; align-items: center; margin-bottom: 10px;">
                            <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                            <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                                ملاحظات حول التحويل:
                            </h4>
                        </div>
                        <ul style="font-size: 13px; color: #2c3e50; padding-right: 20px; margin: 0;">
                            <li>الرصيد الافتتاحي: تم تحويله باستخدام سعر الصرف الرئيسي</li>
                            <li>الحركات المرتبطة بفواتير: استخدمت سعر الصرف المسجل للفاتورة</li>
                            <li>الحركات المرتبطة بسندات: استخدمت سعر الصرف المسجل للسند</li>
                            <li>الحركات الأخرى: استخدمت سعر الصرف الرئيسي</li>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <!-- Action Buttons -->
                    <div class="action-buttons no-print">
                        <div class="footer-info">
                            <i class="fas fa-file-alt"></i>
                            <?= count($transactions) ?> حركة في الفترة المحددة
                        </div>
                        
                        <div class="button-group">
                            <button type="button" class="btn btn-primary" onclick="printStatement()">
                                <i class="fas fa-print"></i> طباعة الكشف
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير لإكسل
                            </button>
                
                        </div>
                    </div>
                    
                    <!-- Print Footer -->
                    <div class="print-only" style="margin-top: 50px; padding-top: 20px; border-top: 1px solid #ddd;">
                        <div style="display: flex; justify-content: space-between; font-size: 12px; color: #666;">
                            <div>
                                <div>تم الطباعة بواسطة: نظام إدارة الحسابات</div>
                                <div>توقيع المدير: __________________</div>
                            </div>
                            <div style="text-align: left;">
                                <div>صفحة 1 من 1</div>
                                <div>تاريخ الطباعة: <?= date('d/m/Y H:i') ?></div>
                                <?php if ($currency_id): ?>
                                    <div>العملة المعروضة: <?= htmlspecialchars($selected_currency_name) ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>


    <script>
           $(document).ready(function() {
            $('.select2').select2({
                dir: 'rtl',
                width: '100%'
              }).on('select2:open', function () {
        setTimeout(function () {
            var field = document.querySelector('.select2-container--open .select2-search__field');
            if (field) field.focus();
        }, 0);
    });
});
        function showLoader() {
            document.getElementById('loadingOverlay').style.display = 'flex';
            return true;
        }
        
        function selectType(type) {
            document.getElementById('accountType').value = type;
            document.getElementById('accountSelect').value = '';
            document.getElementById('action').value = 'view';
            document.getElementById('statementForm').submit();
        }
        
        function selectAccount(accountId) {
            if (accountId) {
                document.getElementById('accountSelect').value = accountId;
                document.getElementById('action').value = 'view';
                document.getElementById('statementForm').submit();
            }
        }
        
        function printStatement() {
            // جمع جميع المعلمات من الصفحة
            const type = '<?= $type ?>';
            const id = '<?= $id ?>';
            const from = '<?= $from ?>';
            const to = '<?= $to ?>';
            
            // جلب العملة المختارة إذا كانت موجودة
            const currencySelect = document.getElementById('currencySelect');
            const currency_id = currencySelect ? currencySelect.value : '';
            
            // التحقق من البيانات
            if (!type || !id || !from || !to) {
                alert('الرجاء ملء جميع الحقول المطلوبة');
                return;
            }
            
            // بناء رابط الطباعة
            let url = 'print_statement.php?' +
                      'type=' + encodeURIComponent(type) +
                      '&id=' + encodeURIComponent(id) +
                      '&from=' + encodeURIComponent(from) +
                      '&to=' + encodeURIComponent(to);
            
            // إضافة العملة إذا تم اختيارها
            if (currency_id && currency_id !== '') {
                url += '&currency_id=' + encodeURIComponent(currency_id);
            }
            
            // فتح نافذة جديدة للطباعة
            const printWindow = window.open(url, '_blank', 'width=1000,height=700,scrollbars=yes,resizable=yes,toolbar=yes');
            
            // إذا لم تفتح النافذة (بسبب مانع الإعلانات)
            if (!printWindow) {
                alert('يرجى السماح بالنوافذ المنبثقة (popups) لهذا الموقع لعرض تقرير الطباعة');
            }
        }
        
        function exportToExcel() {
            alert('سيتم تطوير هذه الميزة قريباً');
        }
        
        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effect to account cards
            const accountCards = document.querySelectorAll('.account-card');
            accountCards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
            
            // Highlight selected type buttons
            const typeBtns = document.querySelectorAll('.type-btn');
            typeBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    typeBtns.forEach(b => b.classList.remove('active'));
                    this.classList.add('active');
                });
            });
            
            // Add focus effects to form inputs
            const formInputs = document.querySelectorAll('.form-control');
            formInputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.style.borderColor = '#3498db';
                    this.style.boxShadow = '0 0 0 2px rgba(52,152,219,0.2)';
                });
                
                input.addEventListener('blur', function() {
                    this.style.borderColor = '#bdc3c7';
                    this.style.boxShadow = 'none';
                });
            });
        });
        
        // Auto hide loader after 30 seconds (fallback)
        setTimeout(() => {
            const loader = document.getElementById('loadingOverlay');
            if (loader && loader.style.display === 'flex') {
                loader.querySelectorAll('div')[1].textContent = 'لا يزال جاري تحميل البيانات...';
                loader.querySelectorAll('div')[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
            }
        }, 30000);
    </script>
</body>
</html>

<?php
$mysqli->close();
?>