<?php
// print_voucher.php
$page_title = "طباعة السند";
require_once 'config.php';

// التحقق من وجود معرف السند
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die('معرف السند غير موجود');
}

$voucher_id = (int)$_GET['id'];

// جلب بيانات السند مع التفاصيل
$sql = "SELECT v.*, 
               CASE WHEN v.related_to = 'customer' THEN c.name ELSE co.name END as related_name,
               CASE WHEN v.related_to = 'customer' THEN c.phone ELSE co.phone END as related_phone,
               CASE WHEN v.related_to = 'customer' THEN c.address ELSE co.address END as related_address,
               u.username as created_by_name,
               cr.name as currency_name,
               cr.code as currency_code,
               cb.name as cash_box_name,
               ba.name as bank_account_name,
               ba.account_number as bank_account_number
        FROM vouchers v
        LEFT JOIN customers c ON v.related_to = 'customer' AND v.related_id = c.id
        LEFT JOIN companies co ON v.related_to = 'company' AND v.related_id = co.id
        LEFT JOIN users u ON v.created_by = u.id
        LEFT JOIN currencies cr ON v.currency_id = cr.id
        LEFT JOIN cash_boxes cb ON v.cash_box_id = cb.id
        LEFT JOIN bank_accounts ba ON v.bank_account_id = ba.id
        WHERE v.id = ?";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param('i', $voucher_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die('السند غير موجود');
}

$voucher = $result->fetch_assoc();

// جلب أسعار الصرف
$rates_sql = "SELECT c.name, c.code, ver.exchange_rate 
              FROM voucher_exchange_rates ver
              JOIN currencies c ON ver.currency_id = c.id
              WHERE ver.voucher_id = ?";
$rates_stmt = $mysqli->prepare($rates_sql);
$rates_stmt->bind_param('i', $voucher_id);
$rates_stmt->execute();
$rates_result = $rates_stmt->get_result();
$exchange_rates = [];
while ($row = $rates_result->fetch_assoc()) {  // التصحيح هنا: fetch_assoc بدلاً من fetch_assob
    $exchange_rates[] = $row;
}

// تحديد نوع السند
$voucher_type_arabic = $voucher['type'] === 'receipt' ? 'سند قبض' : 'سند صرف';

// تحديد طريقة الدفع
$payment_type_arabic = '';
switch ($voucher['payment_type']) {
    case 'cash':
        $payment_type_arabic = 'نقدي';
        break;
    case 'bank':
        $payment_type_arabic = 'تحويل بنكي';
        break;
    case 'both':
        $payment_type_arabic = 'نقدي وبنكي';
        break;
    default:
        $payment_type_arabic = 'غير محدد';
}

// الحصول على إعدادات الشركة
$company_name = "GUANGZHOU TWO STARS ";
$company_address = ": 606 Liquan Building, No.103, Dongfeng West Road, Liwan District, Guangzhou, Guangdong, China";
$company_phone = "0086 18578773340";
$company_logo = "logo2.png";

// تنسيق التاريخ
$created_date = date('Y/m/d', strtotime($voucher['created_at']));

// تنسيق المبلغ
$amount_formatted = number_format($voucher['amount'], 0);

// تحديد اسم الحساب بناءً على نوع السند وطريقة الدفع
$account_name = "";
if ($voucher['payment_type'] === 'cash' && !empty($voucher['cash_box_name'])) {
    $account_name = "صندوق: " . $voucher['cash_box_name'];
} elseif ($voucher['payment_type'] === 'bank' && !empty($voucher['bank_account_name'])) {
    $account_name = "بنك: " . $voucher['bank_account_name'] . " (" . ($voucher['bank_account_number'] ?? '') . ")";
} else {
    $account_name = "الصندوق الرئيسي";
}

// تحديد أعمدة القيد المحاسبي بناءً على نوع السند
if ($voucher['type'] === 'receipt') {
    // سند قبض: العميل مدين، الصندوق دائن
    $debit_account = $voucher['related_name'] . " (" . ($voucher['related_to'] === 'customer' ? 'عميل' : 'شركة') . ")";
    $debit_amount = $amount_formatted;
    $credit_account = $account_name;
    $credit_amount = $amount_formatted;
} else {
    // سند صرف: الصندوق مدين، العميل دائن
    $debit_account = $account_name;
    $debit_amount = $amount_formatted;
    $credit_account = $voucher['related_name'] . " (" . ($voucher['related_to'] === 'customer' ? 'عميل' : 'شركة') . ")";
    $credit_amount = $amount_formatted;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
        <link rel="stylesheet" href="fontawesome-free-6.7.2-web/css/all.min.css">
     <link rel="stylesheet" href="fonts/Almarai-local/fonts/fonts.css">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> <?php echo $voucher_type_arabic; ?> - <?php echo $voucher['voucher_number']; ?></title>
    <style>
    @font-face {
        font-family: 'Almarai';
        src: url('fonts/Almarai-local/Almarai-Regular.ttf') format('truetype');
        font-weight: normal;
        font-display: swap;
    }

    /* إعدادات الطباعة */
    @media print {
        @page {
            size: Letter portrait;
            margin: 0mm;
        }
        body {
            margin: 0;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
        .no-print { display: none !important; }
    }

    body {
        font-family: 'Almarai', sans-serif;
        width: 210mm;
        min-height: 148mm;
        margin: 0 auto;
        padding: 10px;
        background: #fff;
        font-size: 14px;
        box-sizing: border-box;
        display: flex;
        flex-direction: column;
        position: relative;
    }



    .receipt {
        border: 2px solid #34416E;
        padding: 15px;
        background: #fff;
        z-index: 1;
    }

    /* رأس الصفحة */
    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 5px;
        padding-bottom: 5px;
        border-bottom: 2px solid #34416E;
    }

    .logo {
        flex: 0 0 120px;
        text-align: center;
    }

    .logo img {
        width: 80px;
        transform: scale(1.5);
        transform-origin: center;
    }

    .store-info {
        flex: 1;
        text-align: right;
        padding-right: 20px;
        margin-bottom: 20px;
    }

    .store-name {
        font-size: 22px;
        font-weight: bold;
        margin-bottom: 5px;
        color: #34416E;
    }

    .store-address {
        font-size: 13px;
        color: #666;
    }

    .contact-info {
        font-size: 13px;
        color: #34416E;
        text-align: left;
    }

    .title {
        text-align: center;
        font-size: 20px;
        font-weight: bold;
        margin: 8px 0;
        color: #34416E;
        text-decoration: underline;
    }

    /* تفاصيل أساسية */
    .detail-box-wrapper {
        display: flex;
        flex-wrap: wrap;
        gap: 6px;
        margin-bottom: 5px;
    }

    .detail-box {
    flex: 1 1 45%;
    background: #eeeeee;
    padding: 4px 6px;
    border: 1px solid #34416E;
    border-radius: 4px;
    font-size: 15px;
    font-weight: bold;
    color: #34416E;
    direction: rtl;       /* النص يبدأ من اليمين */
    text-align: right;    /* محاذاة لليمين */
}


    .detail-box span.label {
        color: #5a5a5a;
        font-weight: bold;
        font-size: 14px;
    }

    /* جدول القيد */
    table {
        border-collapse: collapse;
        width: 100%;
        margin-top: 8px;
    }

    table th, table td {
        border: 1px solid #34416E;
        padding: 6px;
        text-align: center;
        font-size: 14px;
    }

    table th {
        background: #f2f2f2;
        font-weight: bold;
        color: #34416E;
    }

    /* التواقيع */
    .signatures {
        display: flex;
        justify-content: space-between;
        margin-top: 25px;
    }

    .sign-box {
        width: 30%;
        text-align: center;
        font-size: 14px;
        color: #34416E;
    }

    .sign-box span {
        display: block;
        margin-top: 50px;
        border-top: 1px dotted #34416E;
    }

        .amount-in-words {
            margin-top: 10px;
            padding: 8px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            color: #333;
            text-align: right;
        }
           .no-print {
        text-align: center;
        margin-bottom: 10px;
    }

    .no-print button {
        color: white;
        border: none;
        padding: 10px 13px;
        border-radius: 8px;
        font-size: 18px;
        margin: 4px;
        cursor: pointer;
        transition: all 0.25s ease-in-out;
    }

    .no-print button.print-btn { background: #34416E; }
    .no-print button.whatsapp-btn { background: #25D366; }
    .no-print button.close-btn { background: #dc3545; }
    .no-print button.pdf-btn { background: #e74c3c; }

    .no-print button.print-btn:hover { background: #465493; transform: scale(1.1); }
    .no-print button.whatsapp-btn:hover { background: #2fe97a; transform: scale(1.1); }
    .no-print button.close-btn:hover { background: #e64a59; transform: scale(1.1); }
    .no-print button.pdf-btn:hover { background: #c0392b; transform: scale(1.1); }

    .no-print button:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }
    </style>
</head>
<body>

    <div class="receipt">
        <!-- رأس -->
        <div class="header-container">
            <div class="logo">
                <img src="<?php echo $company_logo; ?>" alt="شعار">
            </div>
            <div class="store-info">
                <div class="store-name"><?php echo $company_name; ?></div>
                <div class="store-address"><?php echo $company_address; ?></div>
            </div>
           <div class="contact-info">
    <i class="fa-solid fa-phone"> :</i>
    <?php echo $company_phone; ?>
</div>

        </div>

        <div class="title"><?php echo $voucher_type_arabic; ?></div>

        <!-- بيانات السند -->
        <div class="detail-box-wrapper">
            <div class="detail-box"><span class="label">رقم السند:</span> <?php echo $voucher['voucher_number']; ?></div>
            <div class="detail-box"><span class="label">التاريخ:</span> <?php echo $created_date; ?></div>
            <div class="detail-box"><span class="label">تم التسليم لـ:</span> <?php echo htmlspecialchars($voucher['related_name']); ?></div>
            <div class="detail-box"><span class="label">المبلغ:</span> <?php echo $amount_formatted; ?> <?php echo $voucher['currency_code']; ?></div>
            <div class="detail-box" style="flex:1 1 100%; direction: rtl; text-align: right;">
                <span class="label">البيان:</span> <?php echo htmlspecialchars($voucher['description'] ?? 'بدون وصف'); ?>
            </div>
        </div>

        <!-- المبلغ كتابة -->
<div class="detail-box" style="flex:1 1 100%; direction: rtl; text-align: right; font-size: 12px;">
    <span class="label">المبلغ كتابةً:</span>
    <span id="amount-words"></span>
</div>


        <?php if ($voucher['type'] === 'receipt'): ?>
            <p>تقييد المبلغ إلى حساب:</p>
        <?php else: ?>
            <p>تقييد المبلغ من حساب:</p>
        <?php endif; ?>

        <!-- جدول القيد المحاسبي -->
        <table>
            <tr>
                <th>م</th>
                <th>رقم الحساب</th>
                 <th>دائن ’’له‘‘</th>
                <th>مدين ’’عليه‘‘</th>
               
                <th>العملة</th>
                <th>البيان</th>
            </tr>
            <?php if ($voucher['type'] === 'receipt'): ?>
            <!-- سند قبض -->
            <tr>
                <td>1</td>
                <td><?php echo htmlspecialchars($debit_account); ?></td>
                <td><?php echo $debit_amount; ?></td>
                <td></td>
                <td><?php echo $voucher['currency_code']; ?></td>
                <td><?php echo htmlspecialchars($voucher['description'] ?? ''); ?></td>
            </tr>
            <tr>
                <td>2</td>
                <td><?php echo htmlspecialchars($credit_account); ?></td>
                <td></td>
                <td><?php echo $credit_amount; ?></td>
                <td><?php echo $voucher['currency_code']; ?></td>
                <td><?php echo htmlspecialchars($voucher['description'] ?? ''); ?></td>
            </tr>
            <?php else: ?>
            <!-- سند صرف -->
            <tr>
                <td>1</td>
                <td><?php echo htmlspecialchars($debit_account); ?></td>
                <td><?php echo $debit_amount; ?></td>
                <td></td>
                <td><?php echo $voucher['currency_code']; ?></td>
                <td><?php echo htmlspecialchars($voucher['description'] ?? ''); ?></td>
            </tr>
            <tr>
                <td>2</td>
                <td><?php echo htmlspecialchars($credit_account); ?></td>
                <td></td>
                <td><?php echo $credit_amount; ?></td>
                <td><?php echo $voucher['currency_code']; ?></td>
                <td><?php echo htmlspecialchars($voucher['description'] ?? ''); ?></td>
            </tr>
            <?php endif; ?>
        </table>

     <!-- أسعار الصرف -->
<?php if (!empty($exchange_rates)): ?>
<div style="margin-top: 15px; font-size: 12px; color:#34416E;">
    <strong>أسعار الصرف:</strong>
    <?php
        $rates = [];
        foreach ($exchange_rates as $rate) {
            $rates[] = $rate['code'] . ' : ' . number_format($rate['exchange_rate'], 4);
        }
        echo implode('  -  ', $rates);
    ?>
</div>
<?php endif; ?>


        <!-- التواقيع -->
        <div class="signatures">
            <div class="sign-box">الصندوق<span></span></div>
            <div class="sign-box">الحسابات<span></span></div>
            <div class="sign-box">الإدارة<span></span></div>
        </div>

        <!-- التذييل -->
        <div style="text-align: center; margin-top: 14px; font-size: 11px; color: #666; border-top: 1px solid #eee; padding-top: 5px;">
            <div>تم الإنشاء بواسطة: <?php echo $voucher['created_by_name']; ?></div>
                 <div style="margin-top: 2px;" >نوع الدفع: <?php echo $payment_type_arabic; ?></div>
              <div style="margin-top: 3px;" >رقم المرجع: <?php echo $voucher['voucher_number']; ?></div>
        </div>
        
    </div>
 <div class="no-print text-center mt-3">
            <button class="print-btn" onclick="window.print()" title="طباعة">
                <i class="fa-solid fa-floppy-disk"></i>
            </button>


            <button class="close-btn" onclick="window.close()" title="إغلاق">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
    <script>
        // دالة لتحويل الأرقام إلى كلمات عربية
      function numberToArabicWords(num) {
    const units = [
        '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة',
        'ستة', 'سبعة', 'ثمانية', 'تسعة'
    ];

    const tens = [
        '', 'عشرة', 'عشرون', 'ثلاثون', 'أربعون',
        'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
    ];

    const teens = [
        'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر',
        'أربعة عشر', 'خمسة عشر', 'ستة عشر',
        'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
    ];

    const hundreds = [
        '', 'مائة', 'مئتان', 'ثلاثمائة', 'أربعمائة',
        'خمسمائة', 'ستمائة', 'سبعمائة',
        'ثمانمائة', 'تسعمائة'
    ];

    if (num === 0) return 'صفر';

    function convert(n) {
        let words = '';

        if (n >= 1000000) {
            const millions = Math.floor(n / 1000000);
            if (millions === 1) words += 'مليون';
            else if (millions === 2) words += 'مليونان';
            else words += convert(millions) + ' ملايين';

            const remainder = n % 1000000;
            if (remainder) words += ' و ' + convert(remainder);
            return words;
        }

        if (n >= 1000) {
            const thousands = Math.floor(n / 1000);
            if (thousands === 1) words += 'ألف';
            else if (thousands === 2) words += 'ألفان';
            else if (thousands <= 10) words += convert(thousands) + ' آلاف';
            else words += convert(thousands) + ' ألف';

            const remainder = n % 1000;
            if (remainder) words += ' و ' + convert(remainder);
            return words;
        }

        if (n >= 100) {
            words += hundreds[Math.floor(n / 100)];
            const remainder = n % 100;
            if (remainder) words += ' و ' + convert(remainder);
            return words;
        }

        if (n >= 20) {
            const u = n % 10;
            if (u) words += units[u] + ' و ';
            words += tens[Math.floor(n / 10)];
            return words;
        }

        if (n >= 10) return teens[n - 10];
        return units[n];
    }

    return convert(Math.floor(num));
}


        // تحديث نص المبلغ بالكلمات
        document.addEventListener('DOMContentLoaded', function() {
            const amount = <?php echo $voucher['amount']; ?>;
            const amountWords = numberToArabicWords(amount);
            document.getElementById('amount-words').textContent = 'فقط ' + amountWords + ' <?php echo $voucher['currency_name']; ?> لا غير';
        });

        // الطباعة التلقائية
     
    </script>
</body>
</html>