<?php
// vouchers.php
$page_title = "إدارة سندات القبض والصرف";
require_once 'config.php';

$message = '';
$action = $_POST['action'] ?? '';
$is_edit_mode = false;
$edit_voucher_data = null;

// معالجة معاملات البحث
$search = $_GET['search'] ?? '';
$search_field = $_GET['search_field'] ?? 'voucher_number';

// معالجة إنشاء السندات
if($action === 'create_voucher'){
    $type = $_POST['type'];
    $amount = (float)$_POST['amount'];
    $currency_id = (int)$_POST['currency_id'];
    $exchange_rates = $_POST['exchange_rates'] ?? [];

    $related_to = $_POST['related_to'];
    $related_id = (int)$_POST['related_id'];
    $payment_type = $_POST['payment_type'];
    $cash_box_id = isset($_POST['cash_box_id']) ? (int)$_POST['cash_box_id'] : null;
    $bank_account_id = isset($_POST['bank_account_id']) ? (int)$_POST['bank_account_id'] : null;
    $description = sanitize($_POST['description'] ?? '');
    $voucher_number = 'VCHR-'.date('YmdHis').rand(100,999);
    $created_by = current_user_id();
    
    $sql = "INSERT INTO vouchers 
    (voucher_number, type, amount, currency_id, related_to, related_id,
     cash_box_id, bank_account_id, description, created_by, created_at,
     payment_type, voucher_date)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($sql);
    $t = date('Y-m-d H:i:s');
    $voucher_date = $t;
    $stmt->bind_param(
        'ssdisiiisisss',
        $voucher_number,
        $type,
        $amount,
        $currency_id,
        $related_to,
        $related_id,
        $cash_box_id,
        $bank_account_id,
        $description,
        $created_by,
        $t,
        $payment_type,
        $voucher_date
    );
    
    if(!$stmt->execute()){
        $message = 'خطأ عند حفظ السند: '.$stmt->error;
    } else {
        $voucher_id = $stmt->insert_id;
        $rateStmt = $mysqli->prepare("
            INSERT INTO voucher_exchange_rates
            (voucher_id, currency_id, exchange_rate)
            VALUES (?, ?, ?)
        ");

        foreach ($exchange_rates as $curId => $rate) {
    $currencyIdTmp = (int)$curId;
    $rateTmp = (float)$rate;

    $rateStmt->bind_param(
        'iid',
        $voucher_id,
        $currencyIdTmp,
        $rateTmp
    );
    $rateStmt->execute();
}

        $rateStmt->close();

        $stmt->close();
        
        // تسجيل القيود المحاسبية
        $cash_amount = 0.00; $bank_amount = 0.00;
        if($payment_type === 'cash') $cash_amount = $amount;
        elseif($payment_type === 'bank') $bank_amount = $amount;
        elseif($payment_type === 'both'){
            $cash_amount = (float)($_POST['cash_amount'] ?? 0);
            $bank_amount = $amount - $cash_amount;
        }
        
        // الوظيفة المساعدة لتطبيق المعاملات
        $apply_container = function(
    $container_type,
    $container_id,
    $trx_type, // receipt | payment
    $debit,
    $credit,
    $desc,
    $payment_method
) use ($mysqli, $voucher_id){

    $newbal = insert_transaction(
        $mysqli,
        date('Y-m-d'),
        $container_type,
        $trx_type,
        $container_id,
        null,
        $voucher_id,
        $debit,
        $credit,
        $desc,
        $payment_method
    );

    if($container_type === 'cash') update_container_balance($mysqli, 'cash_boxes', $container_id, $newbal);
    if($container_type === 'bank') update_container_balance($mysqli, 'bank_accounts', $container_id, $newbal);
};

        // اسم الطرف المقابل
        $related_name = '';
        if($related_to === 'customer'){
            $r = $mysqli->query("SELECT name FROM customers WHERE id=$related_id LIMIT 1");
            $related_name = $r->fetch_row()[0] ?? '';
        } else {
            $r = $mysqli->query("SELECT name FROM companies WHERE id=$related_id LIMIT 1");
            $related_name = $r->fetch_row()[0] ?? '';
        }
        
      if($type === 'receipt'){
    // سند قبض
    if($cash_amount > 0 && $cash_box_id){
        $desc = "سند قبض من {$related_to} ($related_name) - $voucher_number";
        $apply_container('cash', $cash_box_id, 'receipt', $cash_amount, 0.00, $desc, 'cash');
    }
    if($bank_amount > 0 && $bank_account_id){
        $desc = "سند قبض من {$related_to} ($related_name) - $voucher_number";
        $apply_container('bank', $bank_account_id, 'receipt', $bank_amount, 0.00, $desc, 'bank');
    }
    
    $related_desc = "سند قبض #$voucher_number - {$description}";
    insert_transaction($mysqli, date('Y-m-d'), $related_to, 'receipt', $related_id, null, $voucher_id, 0.00, $amount, $related_desc, 'cash');
    
    $last = get_last_balance($mysqli, $related_to, $related_id);
    $new_balance = $last - $amount;
    
    if($related_to === 'customer'){
        $upd = $mysqli->prepare("UPDATE customers SET current_balance=? WHERE id=?");
        $upd->bind_param('di', $new_balance, $related_id);
        $upd->execute();
        $upd->close();
    } else {
        $upd = $mysqli->prepare("UPDATE companies SET current_balance=? WHERE id=?");
        $upd->bind_param('di', $new_balance, $related_id);
        $upd->execute();
        $upd->close();
    }
} else { // payment
    // سند صرف
    if($cash_amount > 0 && $cash_box_id){
        $desc = "سند صرف الى {$related_to} ($related_name) - $voucher_number";
        $apply_container('cash', $cash_box_id, 'payment', 0.00, $cash_amount, $desc, 'cash');
    }
    if($bank_amount > 0 && $bank_account_id){
        $desc = "سند صرف الى {$related_to} ($related_name) - $voucher_number";
        $apply_container('bank', $bank_account_id, 'payment', 0.00, $bank_amount, $desc, 'bank');
    }
    
    $related_desc = "سند صرف #$voucher_number - {$description}";
    insert_transaction($mysqli, date('Y-m-d'), $related_to, 'payment', $related_id, null, $voucher_id, $amount, 0.00, $related_desc, 'cash');

    if($related_to === 'customer'){
        $last = get_last_balance($mysqli, $related_to, $related_id);
        $new_balance = $last + $amount;
        $upd = $mysqli->prepare("UPDATE customers SET current_balance=? WHERE id=?");
        $upd->bind_param('di', $new_balance, $related_id);
        $upd->execute();
        $upd->close();
    } else {
        $last = get_last_balance($mysqli, $related_to, $related_id);
        $new_balance = $last + $amount;
        $upd = $mysqli->prepare("UPDATE companies SET current_balance=? WHERE id=?");
        $upd->bind_param('di', $new_balance, $related_id);
        $upd->execute();
        $upd->close();
    }
}

log_activity($mysqli, current_user_id(), 'create', 'voucher', $voucher_id, null, json_encode(['voucher_number'=>$voucher_number,'amount'=>$amount,'type'=>$type]));
$_SESSION['message'] = 'تم حفظ السند والمقيد المحاسبي بنجاح.';
header("Location: vouchers.php");
exit;
    }}

// معالجة تحديث السندات
if($action === 'update_voucher'){
    $voucher_id = (int)$_POST['voucher_id'];
    $type = $_POST['type'];
    $amount = (float)$_POST['amount'];
    $currency_id = (int)$_POST['currency_id'];
    $exchange_rates = $_POST['exchange_rates'] ?? [];

    $related_to = $_POST['related_to'];
    $related_id = (int)$_POST['related_id'];
    $payment_type = $_POST['payment_type'];
    $cash_box_id = isset($_POST['cash_box_id']) ? (int)$_POST['cash_box_id'] : null;
    $bank_account_id = isset($_POST['bank_account_id']) ? (int)$_POST['bank_account_id'] : null;
    $description = sanitize($_POST['description'] ?? '');
    
    // بدء المعاملة
    $mysqli->begin_transaction();
    
    try {
        // 1. جلب بيانات السند القديم
        $old_voucher_result = $mysqli->query("SELECT * FROM vouchers WHERE id = $voucher_id");
        $old_voucher = $old_voucher_result->fetch_assoc();
        
        if(!$old_voucher) {
            throw new Exception('السند غير موجود');
        }
        
        // 2. التراجع عن التأثيرات القديمة
        // حذف الحركات المالية القديمة
        $mysqli->query("DELETE FROM transactions WHERE related_voucher_id = $voucher_id");
        
        // التراجع عن تحديث أرصدة العملاء/الشركات
        $old_amount = $old_voucher['amount'];
        $old_related_to = $old_voucher['related_to'];
        $old_related_id = $old_voucher['related_id'];
        
        if($old_related_to === 'customer') {
            $table = 'customers';
        } else {
            $table = 'companies';
        }
        
        // الحصول على الرصيد الحالي
        $current = $mysqli->query("SELECT current_balance FROM $table WHERE id = $old_related_id")->fetch_row();
        $current_balance = $current[0] ?? 0;
        
        // حساب الرصيد الجديد (التراجع)
        if($old_voucher['type'] === 'receipt') {
            // سند قبض: كنا خصمنا المبلغ، الآن نرجعه
            $new_balance = $current_balance + $old_amount;
        } else {
            // سند صرف: كنا أضفنا المبلغ، الآن نخصمه
            $new_balance = $current_balance - $old_amount;
        }
        
        $mysqli->query("UPDATE $table SET current_balance = $new_balance WHERE id = $old_related_id");
        
        // التراجع عن تحديث أرصدة الصناديق والحسابات البنكية
        if($old_voucher['payment_type'] === 'cash' && $old_voucher['cash_box_id']) {
            $current_cash = $mysqli->query("SELECT current_balance FROM cash_boxes WHERE id = {$old_voucher['cash_box_id']}")->fetch_row()[0];
            if($old_voucher['type'] === 'receipt') {
                $new_cash = $current_cash - $old_amount; // سحب المبلغ من الصندوق
            } else {
                $new_cash = $current_cash + $old_amount; // إعادة المبلغ للصندوق
            }
            $mysqli->query("UPDATE cash_boxes SET current_balance = $new_cash WHERE id = {$old_voucher['cash_box_id']}");
        }
        
        if($old_voucher['payment_type'] === 'bank' && $old_voucher['bank_account_id']) {
            $current_bank = $mysqli->query("SELECT current_balance FROM bank_accounts WHERE id = {$old_voucher['bank_account_id']}")->fetch_row()[0];
            if($old_voucher['type'] === 'receipt') {
                $new_bank = $current_bank - $old_amount;
            } else {
                $new_bank = $current_bank + $old_amount;
            }
            $mysqli->query("UPDATE bank_accounts SET current_balance = $new_bank WHERE id = {$old_voucher['bank_account_id']}");
        }

        // 3. تحديث بيانات السند
        $update_sql = "UPDATE vouchers SET 
                      type = ?, amount = ?, currency_id = ?, related_to = ?, related_id = ?,
                      cash_box_id = ?, bank_account_id = ?, description = ?, payment_type = ?
                      WHERE id = ?";
        $stmt = $mysqli->prepare($update_sql);
        $stmt->bind_param('sdisiiissi', 
            $type, $amount, $currency_id, $related_to, $related_id,
            $cash_box_id, $bank_account_id, $description, $payment_type, $voucher_id
        );
        $stmt->execute();
        
        // 4. تحديث أسعار الصرف (حذف القديم وإضافة الجديد)
        $mysqli->query("DELETE FROM voucher_exchange_rates WHERE voucher_id = $voucher_id");
        
        if(count($exchange_rates) > 0) {
            $rateStmt = $mysqli->prepare("
                INSERT INTO voucher_exchange_rates
                (voucher_id, currency_id, exchange_rate)
                VALUES (?, ?, ?)
            ");
            
            foreach ($exchange_rates as $curId => $rate) {
    $currencyIdTmp = (int)$curId;
    $rateTmp = (float)$rate;

    $rateStmt->bind_param(
        'iid',
        $voucher_id,
        $currencyIdTmp,
        $rateTmp
    );
    $rateStmt->execute();
}

            $rateStmt->close();
        }
        
        // 5. تطبيق التأثيرات الجديدة (مثل إنشاء السند)
        $voucher_number = $old_voucher['voucher_number'];
        $created_by = $old_voucher['created_by'];
        
        $cash_amount = 0.00; $bank_amount = 0.00;
        if($payment_type === 'cash') $cash_amount = $amount;
        elseif($payment_type === 'bank') $bank_amount = $amount;
        elseif($payment_type === 'both'){
            $cash_amount = (float)($_POST['cash_amount'] ?? 0);
            $bank_amount = $amount - $cash_amount;
        }
        
        // الوظيفة المساعدة لتطبيق المعاملات
        $apply_container = function($container_type, $container_id, $debit, $credit, $desc, $payment_method) use ($mysqli, $voucher_id){
            $newbal = insert_transaction($mysqli, date('Y-m-d'), $container_type, 'receipt', $container_id, null, $voucher_id, $debit, $credit, $desc, $payment_method);
            if($container_type === 'cash') update_container_balance($mysqli, 'cash_boxes', $container_id, $newbal);
            if($container_type === 'bank') update_container_balance($mysqli, 'bank_accounts', $container_id, $newbal);
        };
        
        // اسم الطرف المقابل
        $related_name = '';
        if($related_to === 'customer'){
            $r = $mysqli->query("SELECT name FROM customers WHERE id=$related_id LIMIT 1");
            $related_name = $r->fetch_row()[0] ?? '';
        } else {
            $r = $mysqli->query("SELECT name FROM companies WHERE id=$related_id LIMIT 1");
            $related_name = $r->fetch_row()[0] ?? '';
        }
        
        if($type === 'receipt'){
            // سند قبض
            if($cash_amount > 0 && $cash_box_id){
                $desc = "سند قبض من {$related_to} ($related_name) - $voucher_number";
                $apply_container('cash', $cash_box_id, $cash_amount, 0.00, $desc, 'cash');
            }
            if($bank_amount > 0 && $bank_account_id){
                $desc = "سند قبض من {$related_to} ($related_name) - $voucher_number";
                $apply_container('bank', $bank_account_id, $bank_amount, 0.00, $desc, 'bank');
            }
            
            $related_desc = "سند قبض #$voucher_number - {$description}";
            insert_transaction($mysqli, date('Y-m-d'), $related_to, 'receipt', $related_id, null, $voucher_id, 0.00, $amount, $related_desc, 'cash');
            
            $last = get_last_balance($mysqli, $related_to, $related_id);
            $new_balance = $last - $amount;
            
            if($related_to === 'customer'){
                $upd = $mysqli->prepare("UPDATE customers SET current_balance=? WHERE id=?");
                $upd->bind_param('di', $new_balance, $related_id);
                $upd->execute();
                $upd->close();
            } else {
                $upd = $mysqli->prepare("UPDATE companies SET current_balance=? WHERE id=?");
                $upd->bind_param('di', $new_balance, $related_id);
                $upd->execute();
                $upd->close();
            }
        } else { // payment
            // سند صرف
            if($cash_amount > 0 && $cash_box_id){
                $desc = "سند صرف الى {$related_to} ($related_name) - $voucher_number";
                $apply_container('cash', $cash_box_id, 0.00, $cash_amount, $desc, 'cash');
            }
            if($bank_amount > 0 && $bank_account_id){
                $desc = "سند صرف الى {$related_to} ($related_name) - $voucher_number";
                $apply_container('bank', $bank_account_id, 0.00, $bank_amount, $desc, 'bank');
            }
            
            $related_desc = "سند صرف #$voucher_number - {$description}";
            insert_transaction($mysqli, date('Y-m-d'), $related_to, 'payment', $related_id, null, $voucher_id, $amount, 0.00, $related_desc, 'cash');
            
            $last = get_last_balance($mysqli, $related_to, $related_id);
            if($related_to === 'customer'){
                $upd = $mysqli->prepare("UPDATE customers SET current_balance=? WHERE id=?");
                $upd->bind_param('di', $last + $amount, $related_id);
                $upd->execute(); $upd->close();
            } else {
                $upd = $mysqli->prepare("UPDATE companies SET current_balance=? WHERE id=?");
                $upd->bind_param('di', $last + $amount, $related_id);
                $upd->execute(); $upd->close();
            }
        }
        
        $mysqli->commit();
        
        log_activity($mysqli, current_user_id(), 'update', 'voucher', $voucher_id, 
                    json_encode($old_voucher), json_encode($_POST));
        $_SESSION['message'] = 'تم تحديث السند والمقيد المحاسبي بنجاح.';
        header("Location: vouchers.php");
        exit;
        
    } catch (Exception $e) {
        $mysqli->rollback();
        $message = 'خطأ عند تحديث السند: ' . $e->getMessage();
    }
}

// معالجة حذف السند
if (($_POST['action'] ?? '') === 'delete_voucher') {
    try {
        if (empty($_POST['voucher_id'])) {
            throw new Exception("معرف السند مطلوب");
        }
        
        $voucherId = (int)$_POST['voucher_id'];
        
        // حذف السند والبيانات المرتبطة بها
        $stmt = $mysqli->prepare("DELETE FROM voucher_exchange_rates WHERE voucher_id = ?");
        $stmt->bind_param('i', $voucherId);
        $stmt->execute();
        
        $stmt = $mysqli->prepare("DELETE FROM transactions WHERE related_voucher_id = ?");
        $stmt->bind_param('i', $voucherId);
        $stmt->execute();
        
        $stmt = $mysqli->prepare("DELETE FROM vouchers WHERE id = ?");
        $stmt->bind_param('i', $voucherId);
        $stmt->execute();
        
        $_SESSION['message'] = "تم حذف السند بنجاح";
        header("Location: vouchers.php");
        exit;
        
    } catch(Exception $e) {
        $_SESSION['error'] = "خطأ في حذف السند: " . $e->getMessage();
        header("Location: vouchers.php");
        exit;
    }
}

// جلب تفاصيل السند للعرض أو التعديل
if(isset($_GET['get_voucher']) && isset($_GET['id'])) {
    $voucher_id = (int)$_GET['id'];
    
    $voucher = $mysqli->query("
        SELECT v.*, 
        CASE WHEN v.related_to = 'customer' THEN c.name ELSE co.name END as related_name
        FROM vouchers v
        LEFT JOIN customers c ON v.related_to = 'customer' AND v.related_id = c.id
        LEFT JOIN companies co ON v.related_to = 'company' AND v.related_id = co.id
        WHERE v.id = $voucher_id
    ")->fetch_assoc();
    
    if($voucher) {
        $rates_result = $mysqli->query("
            SELECT currency_id, exchange_rate 
            FROM voucher_exchange_rates 
            WHERE voucher_id = $voucher_id
        ");
        
        $exchange_rates = [];
        while($rate = $rates_result->fetch_assoc()) {
            $exchange_rates[$rate['currency_id']] = $rate['exchange_rate'];
        }
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'voucher' => $voucher,
            'exchange_rates' => $exchange_rates
        ]);
        exit;
    }
    
    echo json_encode(['success' => false, 'message' => 'السند غير موجود']);
    exit;
}

// استعلامات لعرض البيانات
$customers = get_customers($mysqli);
$companies = get_companies($mysqli);
$foreign_currencies = $mysqli->query("
    SELECT id, name, code, exchange_rate
    FROM currencies
    WHERE is_default = 0 AND is_active = 1
");
$cash_boxes_list = $mysqli->query("SELECT * FROM cash_boxes WHERE is_active=1 ORDER BY name");
$bank_accounts_list = $mysqli->query("SELECT * FROM bank_accounts WHERE is_active=1 ORDER BY name");

// استعلام للسندات مع دعم البحث
$voucher_query = "
    SELECT v.*, 
    CASE WHEN v.related_to = 'customer' THEN c.name ELSE co.name END as related_name,
    u.username as created_by_name,
    cr.code as currency_code
    FROM vouchers v
    LEFT JOIN customers c ON v.related_to = 'customer' AND v.related_id = c.id
    LEFT JOIN companies co ON v.related_to = 'company' AND v.related_id = co.id
    LEFT JOIN users u ON v.created_by = u.id
    LEFT JOIN currencies cr ON v.currency_id = cr.id
    WHERE 1=1
";

// إضافة شروط البحث إذا وجدت
if (!empty($search)) {
    if ($search_field === 'voucher_number') {
        $voucher_query .= " AND v.voucher_number LIKE '%" . $mysqli->real_escape_string($search) . "%'";
    } elseif ($search_field === 'related_name') {
        $voucher_query .= " AND (c.name LIKE '%" . $mysqli->real_escape_string($search) . "%' OR co.name LIKE '%" . $mysqli->real_escape_string($search) . "%')";
    }
}

$voucher_query .= " ORDER BY v.id DESC";

// تنفيذ الاستعلام
$recent_vouchers = $mysqli->query($voucher_query);

// حساب إحصائيات السندات
$totalVouchers = $recent_vouchers->num_rows;
$receiptCount = 0;
$paymentCount = 0;
$totalAmount = 0;

// حساب الإحصائيات
$recent_vouchers->data_seek(0);
while($voucher = $recent_vouchers->fetch_assoc()) {
    if($voucher['type'] == 'receipt') $receiptCount++;
    if($voucher['type'] == 'payment') $paymentCount++;
    $totalAmount += $voucher['amount'];
}
$recent_vouchers->data_seek(0); // إعادة المؤشر للبداية

// استرجاع الرسائل من الجلسة
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
if (isset($_SESSION['error'])) {
    $error = $_SESSION['error'];
    unset($_SESSION['error']);
}

require_once 'header.php';
?>
<link rel="stylesheet" href="fontawesome-free-6.7.2-web/css/all.min.css">
<script src="jquery-3.6.0.min.js"></script>
<link href="bootstrap.min.css" rel="stylesheet">
<link href="select2.min.css" rel="stylesheet" />
<script src="bootstrap.bundle.min.js"></script>
<script src="select2.min.js"></script>

<style>
/* تنسيقات select2 */
.select2-container--default .select2-selection--single {
    border: 1px solid #bdc3c7 !important;
    border-radius: 0 !important;
    height: 38px !important;
    padding: 5px 10px !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #2c3e50 !important;
    line-height: 1.5 !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #2c3e50 transparent transparent transparent !important;
}

.select2-container--default.select2-container--open .select2-selection--single .select2-selection__arrow b {
    border-color: transparent transparent #2c3e50 transparent !important;
    border-width: 0 4px 5px 4px !important;
}

/* تنسيقات عامة */
.table tbody tr {
    transition: background-color 0.2s ease;
}

.table tbody tr.selected {
    background-color: rgba(14, 66, 98, 0.1) !important;
    border-left: 3px solid #F19E2C;
}

.form-control:focus {
    outline: none;
    border-color: #3498db;
    box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
}

/* إخفاء بعض الأعمدة في الجوال */
@media (max-width: 768px) {
    .table thead th:nth-child(4), /* طريقة الدفع */
    .table tbody td:nth-child(4),
    .table thead th:nth-child(5), /* التاريخ */
    .table tbody td:nth-child(5),
    .table thead th:nth-child(6), /* الإجراءات */
    .table tbody td:nth-child(6) {
        display: none;
    }
    
    .table thead th,
    .table tbody td {
        padding: 8px 5px !important;
    }
}
</style>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-file-invoice-dollar" style="margin-left: 8px;"></i>
                إدارة سندات القبض والصرف
            </h2>
            <button type="button" class="btn" id="newVoucherBtn"
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                <i class="fas fa-plus" style="margin-left: 8px;"></i>
                سند جديد
            </button>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <form method="GET" action="" style="margin-bottom: 10px;">
                <div style="display: flex; gap: 10px;">
                    <div style="position: relative; flex: 1;">
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث برقم السند أو اسم الطرف المقابل..." 
                               value="<?php echo htmlspecialchars($search ?? ''); ?>"
                               style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                    </div>
                    
                    <select name="search_field" class="form-control" 
                            style="width: 200px; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <option value="voucher_number" <?php echo ($search_field === 'voucher_number') ? 'selected' : ''; ?>>رقم السند</option>
                        <option value="related_name" <?php echo ($search_field === 'related_name') ? 'selected' : ''; ?>>الطرف المقابل</option>
                    </select>
                    
                    <button type="submit" class="btn" 
                            style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-search" style="margin-left: 8px;"></i>
                        بحث
                    </button>
                    
                    <?php if (!empty($search)): ?>
                        <a href="vouchers.php" class="btn" 
                           style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-times" style="margin-left: 8px;"></i>
                            إلغاء البحث
                        </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- الإحصائيات -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي السندات</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalVouchers); ?></div>
                </div>
                <div style="background: #d4edda; padding: 15px; border-left: 4px solid #28a745;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">سندات القبض</div>
                    <div style="font-size: 24px; font-weight: bold; color: #155724;"><?php echo number_format($receiptCount); ?></div>
                </div>
                <div style="background: #f8d7da; padding: 15px; border-left: 4px solid #dc3545;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">سندات الصرف</div>
                    <div style="font-size: 24px; font-weight: bold; color: #721c24;"><?php echo number_format($paymentCount); ?></div>
                </div>
                <div style="background: #e8f4fd; padding: 15px; border-left: 4px solid #3498db;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي القيمة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #2980b9;">
                        <?php echo number_format($totalAmount, 2); ?> 
                        <span style="font-size: 14px;">¥</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- رسائل النجاح والخطأ -->
        <?php if ($message): ?>
            <div style="margin: 10px 12px; padding: 8px 12px; background: #d4edda; color: #155724; border: 1px solid #c3e6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-check-circle" style="margin-left: 8px; color: #28a745;"></i>
                    <?php echo htmlspecialchars($message); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #155724; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if (isset($error) && $error): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #dc3545;"></i>
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #721c24; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <!-- نموذج إنشاء/تعديل السند -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1; background: #f8f9fa; display: none;" id="voucherFormContainer">
            <form method="post" id="voucherForm" onsubmit="return validateVoucherForm()">
                <input type="hidden" name="voucher_id" id="voucher_id" value="">
                <input type="hidden" name="action" id="form_action" value="create_voucher">
                <input type="hidden" name="currency_id" value="3">
                
                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; margin-bottom: 15px;">
                    <div>
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">نوع السند</label>
                        <select name="type" class="form-control" required style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;" id="voucher_type">
                            <option value="">-- اختر نوع السند --</option>
                            <option value="receipt">سند قبض</option>
                            <option value="payment">سند صرف</option>
                        </select>
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">المبلغ (¥)</label>
                        <input type="number" name="amount" class="form-control" step="0.01" required 
                               placeholder="0.00" id="amount" min="0" style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;" />
                    </div>
                </div>
                
                <?php if($foreign_currencies->num_rows > 0): ?>
                <div style="background: #f8f9fa; padding: 15px; margin-bottom: 15px; border: 1px solid #dee2e6;">
                    <h5 style="color: #2c3e50; margin-bottom: 10px; font-size: 14px; display: flex; align-items: center;">
                        <i class="fas fa-exchange-alt" style="margin-left: 8px; font-size: 12px;"></i>
                        أسعار الصرف وقت إنشاء السند
                    </h5>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 10px;">
                        <?php 
                        $foreign_currencies->data_seek(0);
                        while($cur = $foreign_currencies->fetch_assoc()): ?>
                            <div>
                                <label style="display: block; margin-bottom: 3px; font-size: 12px; color: #495057;">
                                    <?= htmlspecialchars($cur['name']) ?> (<?= $cur['code'] ?>)
                                </label>
                                <input type="number"
                                       name="exchange_rates[<?= $cur['id'] ?>]"
                                       class="form-control exchange-rate-input"
                                       step="0.000001"
                                       value="<?= $cur['exchange_rate'] ?>"
                                       required
                                       placeholder="سعر الصرف"
                                       id="exchange_rate_<?= $cur['id'] ?>"
                                       style="width: 100%; padding: 6px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 12px;">
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; margin-bottom: 15px;">
                    <div>
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">الطرف المقابل</label>
                        <select name="related_to" id="related_to" class="form-control" required style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;">
                            <option value="">-- اختر نوع الطرف --</option>
                            <option value="customer">عميل</option>
                            <option value="company">شركة / مورد</option>
                        </select>
                    </div>
                    
                    <div>
                        <label id="related_label" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">اختر الطرف</label>
                        <select name="related_id" class="form-control select2" id="related_id" required style="width: 100%;">
                            <option value="">اختر نوع الطرف أولاً</option>
                        </select>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; margin-bottom: 15px;">
                    <div>
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">طريقة الدفع</label>
                        <select name="payment_type" class="form-control" id="payment_type" required style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;">
                            <option value="">-- اختر طريقة الدفع --</option>
                            <option value="cash">نقدي</option>
                            <option value="bank">تحويل بنكي</option>
                            <option value="both">نقدي + بنكي</option>
                        </select>
                    </div>
                    
                    <div id="cash_box_select" style="display:none;">
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">الصندوق النقدي</label>
                        <select name="cash_box_id" class="form-control" id="cash_box_id" style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;">
                            <option value="">-- اختر الصندوق --</option>
                            <?php 
                            $cash_boxes_list->data_seek(0);
                            while($cb = $cash_boxes_list->fetch_assoc()): ?>
                                <option value="<?php echo $cb['id']; ?>" data-balance="<?php echo $cb['current_balance']; ?>">
                                    <?php echo htmlspecialchars($cb['name']); ?> 
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div id="bank_account_select" style="display:none;">
                        <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">الحساب البنكي</label>
                        <select name="bank_account_id" class="form-control" id="bank_account_id" style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;">
                            <option value="">-- اختر الحساب --</option>
                            <?php 
                            $bank_accounts_list->data_seek(0);
                            while($ba = $bank_accounts_list->fetch_assoc()): ?>
                                <option value="<?php echo $ba['id']; ?>" data-balance="<?php echo $ba['current_balance']; ?>">
                                    <?php echo htmlspecialchars($ba['name']); ?> 
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                
                <div id="both_row" style="display:none; margin-bottom: 15px;">
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px;">
                        <div>
                            <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">المبلغ النقدي</label>
                            <input type="number" name="cash_amount" class="form-control" step="0.01" 
                                   value="0" id="cash_amount" placeholder="المبلغ المدفوع نقداً" style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;" />
                        </div>
                        
                        <div>
                            <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">المبلغ البنكي</label>
                            <input type="number" id="bank_calc" class="form-control" readonly 
                                   style="background: #f0f0f0; width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0;" />
                        </div>
                    </div>
                </div>
                
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50; font-size: 14px;">البيان / وصف السند</label>
                    <textarea name="description" class="form-control" rows="2" 
                              placeholder="أدخل وصفاً مفصلاً للسند..." 
                              maxlength="500" id="voucher_description" style="width: 100%; padding: 8px; border: 1px solid #bdc3c7; border-radius: 0; resize: vertical;"></textarea>
                </div>
                
                <div style="display: flex; gap: 10px; justify-content: flex-end;">
                    <button type="button" onclick="hideVoucherForm()" style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                        إلغاء
                    </button>
                    <button type="submit" class="btn" style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        حفظ السند
                    </button>
                </div>
            </form>
        </div>

        <!-- حاوية أزرار الإجراءات (ستظهر عند التحديد) -->
        <div id="actionsContainer" style="max-height: 0; overflow: hidden; transition: max-height 0.3s ease; margin: 0 20px;position: sticky; top: 60px; z-index: 1150;">
            <div style="display: flex; gap: 8px; padding: 15px; background: transparent; border-bottom: 1px solid #ecf0f1; flex-wrap: wrap;">
                <button type="button" class="btn" id="editVoucherBtn"
                        style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#2980b9'"
                        onmouseout="this.style.background='#3498db'">
                    <i class="fas fa-edit" style="margin-left: 5px; font-size: 11px;"></i>
                    تعديل
                </button>

                <button type="button" class="btn" id="viewVoucherBtn"
                        style="padding: 6px 12px; background: #17a2b8; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#138496'"
                        onmouseout="this.style.background='#17a2b8'">
                    <i class="fas fa-eye" style="margin-left: 5px; font-size: 11px;"></i>
                    عرض
                </button>

                <button type="button" class="btn" id="deleteVoucherBtn"
                        style="padding: 6px 12px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#c0392b'"
                        onmouseout="this.style.background='#e74c3c'">
                    <i class="fas fa-trash" style="margin-left: 5px; font-size: 11px;"></i>
                    حذف
                </button>

                <button type="button" class="btn" id="printVoucherBtn"
                        style="padding: 6px 12px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#27ae60'"
                        onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-print" style="margin-left: 5px; font-size: 11px;"></i>
                    طباعة
                </button>
            </div>
        </div>

        <!-- جدول السندات -->
      <!-- جدول السندات -->
<div style="overflow-x: auto;">
    
    <table class="table" style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: #f8f9fa;">
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">رقم السند</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">النوع</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الطرف المقابل</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">المبلغ</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">طريقة الدفع</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">التاريخ</th>
                <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($recent_vouchers->num_rows === 0): ?>
                <tr>
                    <td colspan="8" style="padding: 20px; text-align: center; color: #7f8c8d; font-size: 14px;">
                        <i class="fas fa-file-invoice-dollar" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                        <?php if (!empty($search)): ?>
                            <div>لم يتم العثور على نتائج لبحثك: "<?php echo htmlspecialchars($search ?? ''); ?>"</div>
                        <?php else: ?>
                            لا توجد سندات
                        <?php endif; ?>
                    </td>
                </tr>
            <?php else: 
                $index = 0;
                $recent_vouchers->data_seek(0);
                while ($voucher = $recent_vouchers->fetch_assoc()): 
                    $index++; ?>
                <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s; cursor: pointer;" 
                    onmouseover="this.style.backgroundColor='#f8f9fa'" 
                    onmouseout="this.style.backgroundColor='white'"
                    onclick="selectVoucher(<?php echo $voucher['id']; ?>, this)"
                    data-voucher-id="<?php echo $voucher['id']; ?>"
                    data-voucher-number="<?php echo htmlspecialchars($voucher['voucher_number']); ?>"
                    data-voucher-type="<?php echo $voucher['type']; ?>"
                    data-voucher-amount="<?php echo $voucher['amount']; ?>"
                    data-voucher-currency="<?php echo htmlspecialchars($voucher['currency_code'] ?? ''); ?>"
                    data-related-name="<?php echo htmlspecialchars($voucher['related_name'] ?? ''); ?>"
                    data-related-to="<?php echo $voucher['related_to']; ?>"
                    data-payment-type="<?php echo htmlspecialchars($voucher['payment_type'] ?? ''); ?>"
                    data-description="<?php echo htmlspecialchars($voucher['description'] ?? ''); ?>">
                    
                    <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px; vertical-align: middle;">
                        <?php echo $index; ?>
                    </td>
                    
                    <td style="padding: 12px; vertical-align: middle;">
                        <div style="display: flex; align-items: center; justify-content: flex-end;">
                            <div style="text-align: right;">
                                <strong style="color: #2c3e50; font-size: 14px;">
                                    <?php echo htmlspecialchars($voucher['voucher_number']); ?>
                                </strong>
                                <div style="font-size: 12px; color: #7f8c8d; margin-top: 3px;">
                                    <i class="fas fa-user" style="margin-left: 5px;"></i>
                                    <?php echo htmlspecialchars($voucher['created_by_name'] ?? ''); ?>
                                </div>
                            </div>
                        </div>
                    </td>
                    
                    <td style="padding: 12px; text-align: right; vertical-align: middle;">
                        <?php if($voucher['type'] == 'receipt'): ?>
                            <span style="background: #d4edda; color: #155724; padding: 4px 10px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                <i class="fas fa-download" style="margin-left: 5px;"></i>
                                قبض
                            </span>
                        <?php else: ?>
                            <span style="background: #f8d7da; color: #721c24; padding: 4px 10px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                <i class="fas fa-upload" style="margin-left: 5px;"></i>
                                صرف
                            </span>
                        <?php endif; ?>
                    </td>
                    
                    <td style="padding: 12px; text-align: right; vertical-align: middle;">
                        <div style="color: #2c3e50; font-weight: 500; font-size: 14px;">
                            <?php echo htmlspecialchars($voucher['related_name'] ?? ''); ?>
                        </div>
                        <div style="font-size: 12px; color: #7f8c8d; margin-top: 3px;">
                            <?php echo $voucher['related_to'] == 'customer' ? 'عميل' : 'شركة'; ?>
                        </div>
                    </td>
                    
                    <td style="padding: 12px; text-align: left; vertical-align: middle;">
                        <div style="font-weight: 600; color: <?php echo $voucher['type'] == 'receipt' ? '#27ae60' : '#e74c3c'; ?>; font-size: 14px;">
                            <?php echo number_format($voucher['amount'], 2); ?> 
                            <span style="font-size: 12px; color: #7f8c8d;"><?php echo htmlspecialchars($voucher['currency_code'] ?? ''); ?></span>
                        </div>
                    </td>
                    
                    <td style="padding: 12px; text-align: center; vertical-align: middle;">
                        <?php
                        $paymentTypeText = [
                            'cash' => ['icon' => 'money-bill-wave', 'text' => 'نقدي'],
                            'bank' => ['icon' => 'university', 'text' => 'بنكي'],
                            'both' => ['icon' => 'exchange-alt', 'text' => 'مختلط']
                        ][$voucher['payment_type'] ?? 'cash'] ?? ['icon' => 'question-circle', 'text' => 'غير محدد'];
                        ?>
                        <span style="background: #e8f4fd; padding: 4px 10px; border-radius: 2px; font-size: 12px; color: #3498db;">
                            <i class="fas fa-<?php echo $paymentTypeText['icon']; ?>" style="margin-left: 5px;"></i>
                            <?php echo $paymentTypeText['text']; ?>
                        </span>
                    </td>
                    
                    <td style="padding: 12px; text-align: center; vertical-align: middle;">
                        <div style="color: #34495e; font-size: 14px;">
                            <?php echo date('Y-m-d', strtotime($voucher['created_at'])); ?>
                        </div>
                        <div style="font-size: 12px; color: #95a5a6;">
                            <?php echo date('H:i', strtotime($voucher['created_at'])); ?>
                        </div>
                    </td>
                    
                    <td style="padding: 12px; text-align: center; vertical-align: middle;">
                        <button class="btn" onclick="editVoucher(<?php echo $voucher['id']; ?>)" 
                                style="padding: 4px 8px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 11px; cursor: pointer; margin: 2px;">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="btn" onclick="viewVoucher(<?php echo $voucher['id']; ?>)" 
                                style="padding: 4px 8px; background: #17a2b8; color: white; border: none; border-radius: 0; font-size: 11px; cursor: pointer; margin: 2px;">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button class="btn" onclick="confirmDelete(<?php echo $voucher['id']; ?>, '<?php echo htmlspecialchars($voucher['voucher_number']); ?>')" 
                                style="padding: 4px 8px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 11px; cursor: pointer; margin: 2px;">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endwhile; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalVouchers > 0): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي السندات: <?php echo number_format($totalVouchers); ?> سند
                    <?php if (!empty($search)): ?>
                        <span style="margin-right: 10px;">| نتائج البحث: "<?php echo htmlspecialchars($search); ?>"</span>
                    <?php endif; ?>
                </div>
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-calculator" style="margin-left: 5px;"></i>
                    إجمالي القيمة: <?php echo number_format($totalAmount, 2); ?> ¥
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    <?php if (!empty($search)): ?>
                        لم يتم العثور على نتائج لبحثك
                    <?php else: ?>
                        لا توجد سندات لعرضها
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div id="deleteModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 400px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-trash" style="margin-left: 8px;"></i>
                    تأكيد الحذف
                </h3>
                <button onclick="hideDeleteModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px;">
            <div style="text-align: center; margin-bottom: 20px;">
                <i class="fas fa-exclamation-triangle" style="font-size: 48px; color: #e74c3c; margin-bottom: 15px;"></i>
                <p style="font-size: 16px; color: #2c3e50; margin-bottom: 10px;">هل أنت متأكد من حذف السند؟</p>
                <p style="font-size: 14px; color: #7f8c8d;" id="deleteMessage">
                    سيتم حذف السند رقم <strong id="voucherNumber"></strong> وجميع البيانات المرتبطة بها ولا يمكن التراجع عن هذا الإجراء.
                </p>
            </div>
            <div style="display: flex; gap: 10px; justify-content: flex-end;">
                <button onclick="hideDeleteModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                    إلغاء
                </button>
                <form method="POST" id="deleteForm" style="margin: 0;">
                    <input type="hidden" name="action" value="delete_voucher">
                    <input type="hidden" name="voucher_id" id="deleteVoucherId">
                    <button type="submit" style="padding: 8px 20px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                        نعم، احذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- نافذة عرض تفاصيل السند -->
<div id="viewVoucherModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 600px; max-height: 90vh; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2); display: flex; flex-direction: column;">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-file-invoice-dollar" style="margin-left: 8px;"></i>
                    تفاصيل السند
                </h3>
                <button onclick="hideViewVoucherModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px; overflow-y: auto; flex: 1;" id="voucherDetails">
            <!-- سيتم تعبئة البيانات هنا عبر JavaScript -->
        </div>
        <div style="padding: 15px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; display: flex; justify-content: flex-end; gap: 10px;">
            <button onclick="hideViewVoucherModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                إغلاق
            </button>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // تهيئة select2
    $('.select2').select2({
        dir: 'rtl',
        width: '100%'
    }).on('select2:open', function() {
        setTimeout(function() {
            var field = document.querySelector('.select2-container--open .select2-search__field');
            if (field) field.focus();
        }, 0);
    });
});

// بيانات العملاء والشركات
const customers = [
    <?php 
    $customers->data_seek(0);
    while($customer = $customers->fetch_assoc()): 
        echo "{id: " . $customer['id'] . ", name: '" . addslashes($customer['name']) . "', balance: " . ($customer['current_balance'] ?? 0) . "},";
    endwhile; 
    ?>
];

const companies = [
    <?php 
    $companies->data_seek(0);
    while($company = $companies->fetch_assoc()): 
        echo "{id: " . $company['id'] . ", name: '" . addslashes($company['name']) . "', balance: " . ($company['current_balance'] ?? 0) . "},";
    endwhile; 
    ?>
];

// متغيرات عالمية لتخزين السند المحدد
let selectedVoucherId = null;
let selectedVoucherNumber = null;
let selectedVoucherElement = null;

// إظهار نموذج السند
document.getElementById('newVoucherBtn').onclick = function() {
    document.getElementById('voucherForm').reset();
    document.getElementById('voucher_id').value = '';
    document.getElementById('form_action').value = 'create_voucher';
    document.getElementById('related_id').disabled = true;
    document.getElementById('related_id').innerHTML = '<option value="">اختر نوع الطرف أولاً</option>';
    
    // إعادة تعيين select2
    $('#related_id').val('').trigger('change');
    
    updatePaymentFields();
    document.getElementById('voucherFormContainer').style.display = 'block';
    hideActionsContainer();
    
    // إزالة التحديد من الصف
    if (selectedVoucherElement) {
        selectedVoucherElement.classList.remove('selected');
        selectedVoucherElement = null;
        selectedVoucherId = null;
    }
};

// إخفاء نموذج السند
function hideVoucherForm() {
    document.getElementById('voucherFormContainer').style.display = 'none';
}

// اختيار سند
function selectVoucher(voucherId, element) {
    // إلغاء تحديد الصف السابق إذا كان موجوداً
    if (selectedVoucherElement) {
        selectedVoucherElement.classList.remove('selected');
    }

    // تحديد الصف الجديد
    element.classList.add('selected');
    selectedVoucherElement = element;

    // حفظ بيانات السند المحدد
    selectedVoucherId = voucherId;
    selectedVoucherNumber = element.getAttribute('data-voucher-number');

    // تحديث روابط الأزرار
    updateActionButtons();

    // إظهار حاوية الأزرار
    showActionsContainer();

    // إخفاء نموذج السند
    hideVoucherForm();

    // تمرير سلس إلى الصف المحدد في الجوال
    if (window.innerWidth <= 768) {
        setTimeout(() => {
            const actionsContainer = document.getElementById('actionsContainer');
            actionsContainer.style.maxHeight = actionsContainer.scrollHeight + 'px';
            actionsContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 300);
    }
}

// تحديث روابط الأزرار بناءً على السند المحدد
function updateActionButtons() {
    if (!selectedVoucherId) return;

    // إعداد معالج الأحداث للأزرار
    document.getElementById('editVoucherBtn').onclick = () => editVoucher(selectedVoucherId);
    document.getElementById('viewVoucherBtn').onclick = () => viewVoucher(selectedVoucherId);
    document.getElementById('deleteVoucherBtn').onclick = () => confirmDelete(selectedVoucherId, selectedVoucherNumber);
    document.getElementById('printVoucherBtn').onclick = () => printVoucher(selectedVoucherId);

}

// إظهار حاوية أزرار الإجراءات
function showActionsContainer() {
    const container = document.getElementById('actionsContainer');
    container.style.maxHeight = container.scrollHeight + 'px';
}

// إخفاء حاوية أزرار الإجراءات
function hideActionsContainer() {
    const container = document.getElementById('actionsContainer');
    container.style.maxHeight = '0';
}

// تأكيد حذف السند
function confirmDelete(voucherId, voucherNumber) {
    document.getElementById('deleteVoucherId').value = voucherId;
    document.getElementById('voucherNumber').textContent = voucherNumber;
    document.getElementById('deleteMessage').innerHTML =
        `سيتم حذف السند رقم <strong>${voucherNumber}</strong> وجميع البيانات المرتبطة به ولا يمكن التراجع عن هذا الإجراء.`;

    document.getElementById('deleteModal').style.display = 'flex';
}

// طباعة السند
function printVoucher(voucherId) {
    window.open(`print_voucher.php?id=${voucherId}`, '_blank');
}

// عرض تفاصيل السند
async function viewVoucher(voucherId) {
    try {
        const response = await fetch(`vouchers.php?get_voucher=1&id=${voucherId}`);
        const data = await response.json();
        
        if (data.success) {
            const voucher = data.voucher;
            
            const typeText = voucher.type === 'receipt' ? 'قبض' : 'صرف';
            const typeColor = voucher.type === 'receipt' ? '#28a745' : '#e74c3c';
            
            const paymentTypeText = {
                'cash': 'نقدي',
                'bank': 'بنكي',
                'both': 'مختلط'
            }[voucher.payment_type] || 'غير محدد';
            
            document.getElementById('voucherDetails').innerHTML = `
                <div style="margin-bottom: 20px;">
                    <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                        <i class="fas fa-file-invoice-dollar" style="margin-left: 8px;"></i>
                        معلومات السند
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #3498db;">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">رقم السند</div>
                            <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">${voucher.voucher_number}</div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid ${typeColor};">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">النوع</div>
                            <div style="font-size: 16px; font-weight: 600; color: ${typeColor};">
                                سند ${typeText}
                            </div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #2ecc71;">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">الطرف المقابل</div>
                            <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">${voucher.related_name}</div>
                            <div style="font-size: 12px; color: #7f8c8d;">(${voucher.related_to === 'customer' ? 'عميل' : 'شركة'})</div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #9b59b6;">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">التاريخ</div>
                            <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">
                                ${new Date(voucher.created_at).toLocaleDateString('ar-EG')}
                            </div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #f39c12;">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">طريقة الدفع</div>
                            <div style="font-size: 16px; font-weight: 600; color: #f39c12;">
                                ${paymentTypeText}
                            </div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #e74c3c;">
                            <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">المبلغ</div>
                            <div style="font-size: 16px; font-weight: 600; color: ${typeColor};">
                                ${parseFloat(voucher.amount).toFixed(2)} ¥
                            </div>
                        </div>
                    </div>
                </div>
                
                ${voucher.description ? `
                <div style="margin-bottom: 20px;">
                    <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                        <i class="fas fa-align-left" style="margin-left: 8px;"></i>
                        الوصف
                    </h4>
                    <div style="background: #f8f9fa; padding: 15px; border-radius: 0; color: #495057; line-height: 1.6;">
                        ${voucher.description}
                    </div>
                </div>
                ` : ''}
            `;
            
            document.getElementById('viewVoucherModal').style.display = 'flex';
        } else {
            alert('خطأ في جلب بيانات السند: ' + data.message);
        }
    } catch(error) {
        alert('حدث خطأ في الشبكة: ' + error);
    }
}
function printVoucher(voucherId) {
    // فتح صفحة الطباعة في نافذة جديدة
    window.open(`print_voucher.php?id=${voucherId}`, '_blank', 'width=800,height=600');
}

// تحرير السند
async function editVoucher(voucherId) {
    try {
        const response = await fetch(`vouchers.php?get_voucher=1&id=${voucherId}`);
        const data = await response.json();
        
        if (data.success) {
            const voucher = data.voucher;
            
            // تعبئة النموذج
            document.getElementById('voucher_id').value = voucher.id;
            document.getElementById('form_action').value = 'update_voucher';
            document.getElementById('voucher_type').value = voucher.type;
            document.getElementById('amount').value = voucher.amount;
            
            // تعبئة أسعار الصرف إذا كانت موجودة
            if (data.exchange_rates) {
                for (const [currencyId, rate] of Object.entries(data.exchange_rates)) {
                    const input = document.querySelector(`input[name="exchange_rates[${currencyId}]"]`);
                    if (input) {
                        input.value = rate;
                    }
                }
            }
            
            // تعبئة الطرف المقابل
            document.getElementById('related_to').value = voucher.related_to;
            loadRelatedParties();
            
            // تأخير لضمان تحميل الخيارات
            setTimeout(() => {
                document.getElementById('related_id').value = voucher.related_id;
                $('#related_id').trigger('change');
            }, 300);
            
            document.getElementById('payment_type').value = voucher.payment_type;
            updatePaymentFields();
            
            // تأخير لضمان تحديث الحقول
            setTimeout(() => {
                if (voucher.cash_box_id) {
                    document.getElementById('cash_box_id').value = voucher.cash_box_id;
                }
                
                if (voucher.bank_account_id) {
                    document.getElementById('bank_account_id').value = voucher.bank_account_id;
                }
            }, 400);
            
            document.getElementById('voucher_description').value = voucher.description || '';
            
            // إظهار النموذج
            document.getElementById('voucherFormContainer').style.display = 'block';
            
            // إخفاء أزرار الإجراءات
            hideActionsContainer();
        } else {
            alert('خطأ في جلب بيانات السند: ' + data.message);
        }
    } catch(error) {
        alert('حدث خطأ في الاتصال بالخادم: ' + error);
    }
}

// تحميل الأطراف المقابلة
function loadRelatedParties() {
    const relatedTo = document.getElementById('related_to');
    const relatedSelect = document.getElementById('related_id');
    const v = relatedTo.value;
    
    relatedSelect.innerHTML = '<option value="">-- اختر --</option>';
    
    if(v === 'customer') {
        customers.forEach(customer => {
            const option = document.createElement('option');
            option.value = customer.id;
            option.textContent = `${customer.name}`;
            relatedSelect.appendChild(option);
        });
    } else if(v === 'company') {
        companies.forEach(company => {
            const option = document.createElement('option');
            option.value = company.id;
            option.textContent = `${company.name}`;
            relatedSelect.appendChild(option);
        });
    }
    
    relatedSelect.disabled = false;
    $('#related_id').trigger('change');
}

// تحديث حقول الدفع
function updatePaymentFields() {
    const paymentType = document.getElementById('payment_type');
    const cashSelect = document.getElementById('cash_box_select');
    const bankSelect = document.getElementById('bank_account_select');
    const bothRow = document.getElementById('both_row');
    const v = paymentType.value;
    
    // إظهار/إخفاء الحقول
    cashSelect.style.display = (v === 'cash' || v === 'both') ? 'block' : 'none';
    bankSelect.style.display = (v === 'bank' || v === 'both') ? 'block' : 'none';
    bothRow.style.display = (v === 'both') ? 'block' : 'none';
    
    calculateBankAmount();
}

// حساب المبلغ البنكي
function calculateBankAmount() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const cashAmt = parseFloat(document.getElementById('cash_amount').value) || 0;
    const bankCalc = document.getElementById('bank_calc');
    
    if(bankCalc) { 
        const bankAmount = amount - cashAmt;
        bankCalc.value = bankAmount >= 0 ? bankAmount.toFixed(2) : '0.00';
        
        if(bankAmount < 0) {
            alert('المبلغ النقدي لا يمكن أن يكون أكبر من المبلغ الكلي');
            document.getElementById('cash_amount').value = amount.toFixed(2);
            bankCalc.value = '0.00';
        }
    }
}

// التحقق من النموذج
function validateVoucherForm() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const paymentType = document.getElementById('payment_type').value;
    const cashBox = document.getElementById('cash_box_id');
    const bankAccount = document.getElementById('bank_account_id');
    const cashAmount = parseFloat(document.getElementById('cash_amount').value) || 0;
    
    // التحقق من المبلغ
    if(amount <= 0) {
        alert('يرجى إدخال مبلغ صحيح أكبر من الصفر');
        return false;
    }
    
    // التحقق من طريقة الدفع المختلطة
    if(paymentType === 'both') {
        if(cashAmount <= 0) {
            alert('يرجى إدخال المبلغ النقدي');
            return false;
        }
        
        if(cashAmount > amount) {
            alert('المبلغ النقدي لا يمكن أن يكون أكبر من المبلغ الكلي');
            return false;
        }
    }
    
    // التحقق من اختيار الصناديق والحسابات البنكية
    if(paymentType === 'cash' && (!cashBox || !cashBox.value)) {
        alert('يرجى اختيار الصندوق النقدي');
        return false;
    }
    
    if(paymentType === 'bank' && (!bankAccount || !bankAccount.value)) {
        alert('يرجى اختيار الحساب البنكي');
        return false;
    }
    
    // التحقق من اختيار الطرف المقابل
    const relatedId = document.getElementById('related_id');
    if(!relatedId.value) {
        alert('يرجى اختيار الطرف المقابل');
        return false;
    }
    
    return true;
}

// وظائف إخفاء النوافذ المنبثقة
function hideDeleteModal() {
    document.getElementById('deleteModal').style.display = 'none';
}

function hideViewVoucherModal() {
    document.getElementById('viewVoucherModal').style.display = 'none';
}

// إغلاق النوافذ المنبثقة عند النقر خارجها
window.onclick = function(event) {
    const modals = ['deleteModal', 'viewVoucherModal'];
    modals.forEach(modalId => {
        const modal = document.getElementById(modalId);
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    });
};

// أحداث العناصر
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('related_to').addEventListener('change', loadRelatedParties);
    document.getElementById('payment_type').addEventListener('change', updatePaymentFields);
    document.getElementById('amount').addEventListener('input', calculateBankAmount);
    document.getElementById('cash_amount').addEventListener('input', calculateBankAmount);
    
    // إخفاء حاوية الأزرار عند النقر خارج الجدول
    document.addEventListener('click', function(event) {
        const table = document.querySelector('.table');
        const actionsContainer = document.getElementById('actionsContainer');
        const voucherFormContainer = document.getElementById('voucherFormContainer');

        // التحقق إذا كان النقر على أي من أزرار الإجراءات أو داخل النافذة المنبثقة
        const isModal = event.target.closest('#deleteModal') ||
                        event.target.closest('#viewVoucherModal');
        
        const isActionButton = event.target.closest('#actionsContainer') || 
                              event.target.closest('#newVoucherBtn') ||
                              event.target.closest('.btn') ||
                              isModal;

        // إذا تم النقر خارج الجدول وخارج حاوية الأزرار وخارج النوافذ المنبثقة وخارج نموذج السند
        if (!table.contains(event.target) && !isActionButton && !voucherFormContainer.contains(event.target)) {
            if (selectedVoucherElement) {
                selectedVoucherElement.classList.remove('selected');
                selectedVoucherElement = null;
                selectedVoucherId = null;
                selectedVoucherNumber = null;
                hideActionsContainer();
            }
        }
    });
    
    // إضافة وظيفة البحث السريع
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('.table tbody tr[data-voucher-number]');
            
            rows.forEach(row => {
                const voucherNumber = row.getAttribute('data-voucher-number') || '';
                const relatedName = row.getAttribute('data-related-name') || '';
                
                if (voucherNumber.toLowerCase().includes(searchTerm) || 
                    relatedName.toLowerCase().includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    }
});
</script>