<?php
// منطق التسجيل الحالي يبقى كما هو
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام إدارة GTS</title>
    <link rel="stylesheet" href="fonts/Almarai-local/fonts/fonts.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Almarai', sans-serif;
  
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1px;
        max-width: 1200px;
        }

        .login-container {
            width: 100%;
       
            display: flex;
            min-height: 600px;
           
            border-radius: 0;
        }

        /* الجانب الأيسر - معلومات النظام */
        .system-info {
            flex: 1.2;
            background: linear-gradient(135deg, #2c3e50 0%, #1a252f 100%);
            padding: 40px 30px;
            color: white;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .system-info::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(241, 158, 44, 0.1)"/></svg>');
            background-size: cover;
        }

        .system-header {
            position: relative;
            z-index: 2;
            margin-bottom: 20px;
        }

        .company-logo {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 30px;
        }

        .logo-icon {
            width: 50px;
            height: 50px;
            background: #F19E2C;
            border-radius: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 20px;
            color: white;
        }

        .company-name h1 {
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #F19E2C;
        }

        .company-name p {
            color: rgba(255, 255, 255, 0.8);
            font-size: 13px;
        }

        .system-title {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 10px;
            color: white;
        }

        .system-subtitle {
            color: rgba(255, 255, 255, 0.8);
            font-size: 14px;
            margin-bottom: 30px;
            line-height: 1.6;
        }

        .features-list {
            position: relative;
            z-index: 2;
            flex: 1;
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 15px;
            padding: 12px 15px;
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(10px);
            border-radius: 0;
            border-right: 3px solid #F19E2C;
            transition: all 0.3s ease;
        }

        .feature-item:hover {
            background: rgba(255, 255, 255, 0.12);
            transform: translateX(-5px);
        }

        .feature-icon {
            width: 36px;
            height: 36px;
            background: rgba(241, 158, 44, 0.2);
            border-radius: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #F19E2C;
            font-size: 14px;
        }

        .feature-content h4 {
            font-size: 14px;
            margin-bottom: 3px;
            font-weight: 600;
            color: white;
        }

        .feature-content p {
            font-size: 12px;
            color: rgba(255, 255, 255, 0.7);
            line-height: 1.4;
        }

        .system-stats {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            position: relative;
            z-index: 2;
            padding-top: 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .stat {
            text-align: center;
            flex: 1;
        }

        .stat-number {
            font-size: 18px;
            font-weight: 600;
            color: #F19E2C;
            margin-bottom: 3px;
        }

        .stat-label {
            font-size: 11px;
            color: rgba(255, 255, 255, 0.8);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* الجانب الأيمن - نموذج الدخول */
        .login-form-container {
            flex: 1;
            background: white;
            padding: 40px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .login-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .login-title {
            font-size: 22px;
            color: #2c3e50;
            margin-bottom: 1px;
            font-weight: 600;
            position: relative;
            display: inline-block;
            padding-bottom: 10px;
        }

        

        .login-subtitle {
            color: #7f8c8d;
            font-size: 13px;
            margin-top: 2px;
        }

        .form-wrapper {
            max-width: 400px;
            margin: 0 auto;
            width: 100%;
        }

        /* رسائل الخطأ */
        .alert {
            padding: 12px 15px;
            border-radius: 0;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideDown 0.3s ease;
            font-size: 13px;
        }

        .alert-error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .alert-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* تصميم الحقول */
        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 6px;
            color: #2c3e50;
            font-weight: 600;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .input-with-icon {
            position: relative;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px 12px 40px;
            border: 1px solid #bdc3c7;
            border-radius: 0;
            font-size: 14px;
            font-family: 'Almarai', sans-serif;
            background: white;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: #3498db;
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }

        .input-icon {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #7f8c8d;
            font-size: 14px;
        }

        /* خيارات إضافية */
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            font-size: 13px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 6px;
            cursor: pointer;
            color: #2c3e50;
        }

        .remember-me input[type="checkbox"] {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }

        .forgot-password {
            color: #3498db;
            text-decoration: none;
            font-weight: 500;
        }

        .forgot-password:hover {
            text-decoration: underline;
        }

        /* زر تسجيل الدخول */
        .btn-login {
            width: 100%;
            padding: 14px;
            background: #2c3e50;
            color: white;
            border: none;
            border-radius: 0;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-login:hover {
            background: #1a252f;
        }

        .btn-login:active {
            transform: translateY(1px);
        }

        /* اللودر */
        .loader {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            z-index: 9999;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }

        .loader.active {
            display: flex;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            border-top-color: #F19E2C;
            animation: spin 1s linear infinite;
            margin-bottom: 15px;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .loader-text {
            color: white;
            font-size: 14px;
            font-weight: 600;
        }

        /* تذييل النموذج */
        .login-footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ecf0f1;
            color: #7f8c8d;
            font-size: 11px;
        }

        .copyright {
            margin-bottom: 6px;
        }

        .support-link {
            color: #3498db;
            text-decoration: none;
            font-weight: 600;
        }

        .support-link:hover {
            text-decoration: underline;
        }

        /* تصميم متجاوب */
        @media (max-width: 992px) {
            .login-container {
                flex-direction: column;
                max-width: 500px;
            }
            
            .system-info, .login-form-container {
                padding: 30px 25px;
            }
            
            .system-info {
                border-radius: 0;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 10px;
            }
            
            .login-container {
                border-radius: 0;
            }
            
            .system-info, .login-form-container {
                padding: 25px 20px;
            }
            
            .system-title {
                font-size: 20px;
            }
            
            .login-title {
                font-size: 18px;
            }
            
            .company-name h1 {
                font-size: 18px;
            }
            
            .feature-item {
                padding: 10px 12px;
            }
            
            .form-options {
                flex-direction: column;
                gap: 10px;
                align-items: flex-start;
            }
        }

        /* تنسيقات إضافية متناسقة مع النسق */
        .form-control::placeholder {
            color: #95a5a6;
            font-size: 13px;
        }

        .feature-item .feature-icon i,
        .input-icon i {
            font-size: 14px;
        }

        .btn-login i {
            font-size: 14px;
        }

        /* تأثيرات خاصة */
        .form-control:invalid {
            border-color: #e74c3c;
        }

        .form-control:valid {
            border-color: #2ecc71;
        }

        /* تنسيق خيار تذكرني */
        .remember-me input[type="checkbox"] {
            accent-color: #F19E2C;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- اللودر -->
    <div class="loader" id="pageLoader">
        <div class="spinner"></div>
        <div class="loader-text">جاري التحقق من بيانات الدخول...</div>
    </div>

    <div class="login-container">
        <!-- الجانب الأيسر: معلومات النظام -->
        <div class="system-info">
            <div class="system-header">
                <div class="company-logo">
                    <div class="logo-icon">GTS</div>
                    <div class="company-name">
                        <h1>GTS لمعدات المطبخ المحدودة</h1>
                        <p>نظام الإدارة المتكامل</p>
                    </div>
                </div>
                
                <h2 class="system-title">نظام إدارة الأعمال</h2>
                <p class="system-subtitle">إدارة متكاملة لعمليات الشركة وتتبع المبيعات</p>
            </div>

            <div class="features-list">
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-file-invoice"></i>
                    </div>
                    <div class="feature-content">
                        <h4>إدارة الفواتير</h4>
                        <p>إنشاء وعرض وتعديل الفواتير بسهولة</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="feature-content">
                        <h4>تقارير مفصلة</h4>
                        <p>تقارير مالية وأداء مفصلة بالوقت الحقيقي</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="feature-content">
                        <h4>إدارة العملاء</h4>
                        <p>سجل كامل للعملاء وتاريخ التعاملات</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="feature-content">
                        <h4>صلاحيات آمنة</h4>
                        <p>نظام صلاحيات متكامل للمستخدمين</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-database"></i>
                    </div>
                    <div class="feature-content">
                        <h4>نسخ احتياطي</h4>
                        <p>نسخ احتياطية كاملة للبيانات</p>
                    </div>
                </div>
            </div>

            <div class="system-stats">
                <div class="stat">
                    <div class="stat-number">24/7</div>
                    <div class="stat-label">دعم فني</div>
                </div>
                <div class="stat">
                    <div class="stat-number">99.9%</div>
                    <div class="stat-label">استقرار النظام</div>
                </div>
                <div class="stat">
                    <div class="stat-number">256-bit</div>
                    <div class="stat-label">تشفير آمن</div>
                </div>
            </div>
        </div>

        <!-- الجانب الأيمن: نموذج الدخول -->
        <div class="login-form-container">
            <div class="login-header">
                <h2 class="login-title">تسجيل الدخول</h2>
                <p class="login-subtitle">أدخل بيانات الدخول للوصول إلى النظام</p>
            </div>

            <div class="form-wrapper">
                <?php if (!empty($error)): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i>
                        <span><?php echo htmlspecialchars($error); ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($message)): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <span><?php echo htmlspecialchars($message); ?></span>
                    </div>
                <?php endif; ?>

                <form method="POST" action="" id="loginForm" class="login-form">
                    <div class="form-group">
                        <label class="form-label" for="username">
                            <i class="fas fa-user"></i>
                            اسم المستخدم
                        </label>
                        <div class="input-with-icon">
                            <input type="text" class="form-control" id="username" name="username" required 
                                   placeholder="أدخل اسم المستخدم"
                                   value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
                            <div class="input-icon">
                                <i class="fas fa-user"></i>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="password">
                            <i class="fas fa-lock"></i>
                            كلمة المرور
                        </label>
                        <div class="input-with-icon">
                            <input type="password" class="form-control" id="password" name="password" required 
                                   placeholder="أدخل كلمة المرور">
                            <div class="input-icon">
                                <i class="fas fa-lock"></i>
                            </div>
                        </div>
                    </div>

                    <div class="form-options">
                        <label class="remember-me">
                            <input type="checkbox" name="remember" value="1">
                            <span>تذكرني</span>
                        </label>
                        <a href="#" class="forgot-password">
                            نسيت كلمة المرور؟
                        </a>
                    </div>

                    <button type="submit" class="btn-login">
                        <span id="btnText">تسجيل الدخول</span>
                        <i class="fas fa-sign-in-alt"></i>
                    </button>
                </form>

                <div class="login-footer">
                    <p class="copyright">© 2024 جميع الحقوق محفوظة يافا سوفت للحلول التقنية الذكية.</p>
                    <p>الإصدار: v3.1.0 | للدعم الفني: <a href="tel:+967774243229" class="support-link">00967774243229</a></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const loader = document.getElementById('pageLoader');
            const btnText = document.getElementById('btnText');

            loginForm.addEventListener('submit', function(e) {
                // إظهار اللودر
                loader.classList.add('active');
                btnText.textContent = 'جاري التحقق...';
                
                // منع إعادة الإرسال المتعددة
                e.preventDefault();
                
                // إرسال النموذج بعد تأخير قصير لمحاكاة عملية التحقق
                setTimeout(() => {
                    this.submit();
                }, 1000);
            });

            // إضافة تأثيرات للحقول
            const inputs = document.querySelectorAll('.form-control');
            inputs.forEach(input => {
                // عند التركيز
                input.addEventListener('focus', function() {
                    this.style.borderColor = '#3498db';
                    this.style.boxShadow = '0 0 0 2px rgba(52, 152, 219, 0.2)';
                });
                
                // عند الخروج
                input.addEventListener('blur', function() {
                    this.style.borderColor = this.value ? '#2ecc71' : '#bdc3c7';
                    this.style.boxShadow = 'none';
                });

                // التحقق أثناء الكتابة
                input.addEventListener('input', function() {
                    if (this.value) {
                        this.style.borderColor = '#2ecc71';
                    } else {
                        this.style.borderColor = '#bdc3c7';
                    }
                });
            });

            // إضافة تأثير لإخفاء اللودر عند تحميل الصفحة (للأمان)
            window.addEventListener('pageshow', function(event) {
                if (event.persisted) {
                    loader.classList.remove('active');
                    btnText.textContent = 'تسجيل الدخول';
                }
            });
        });

        // التأكد من إخفاء اللودر إذا تم العودة للصفحة
  
    </script>
</body>
</html>