<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-cube" style="margin-left: 8px;"></i>
                تعديل الصنف
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #3498db; padding: 4px 8px; border-radius: 0;">تعديل بيانات</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #3498db; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري تحديث بيانات الصنف...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="itemForm" onsubmit="showLoader()">
            <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
            
            <div style="padding: 25px;">
                <!-- معلومات أساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #3498db; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم الصنف
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($item['name']); ?>"
                                   placeholder="أدخل اسم الصنف">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="model" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الموديل
                            </label>
                            <input type="text" class="form-control" id="model" name="model" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($item['model']); ?>"
                                   placeholder="أدخل الموديل">
                        </div>
                    </div>
                </div>

                <!-- الصورة -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #9b59b6; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-image" style="margin-left: 8px; color: #9b59b6;"></i>
                            صورة الصنف
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الصورة الحالية
                            </label>
                            <?php if (!empty($item['image'])): ?>
                                <div style="border: 2px solid #ecf0f1; padding: 10px; text-align: center; background: #f8f9fa;">
                                    <img src="uploads/items/<?php echo htmlspecialchars($item['image']); ?>" 
                                         alt="<?php echo htmlspecialchars($item['name']); ?>" 
                                         style="width: 150px; height: 150px; object-fit: cover; margin-bottom: 10px;"
                                         id="currentImage">
                                    <div style="color: #7f8c8d; font-size: 12px;">
                                        <i class="fas fa-image"></i> الصورة الحالية
                                    </div>
                                </div>
                            <?php else: ?>
                                <div style="border: 2px dashed #ecf0f1; padding: 30px; text-align: center; background: #f8f9fa;">
                                    <i class="far fa-image" style="font-size: 48px; color: #bdc3c7; margin-bottom: 10px;"></i>
                                    <div style="color: #7f8c8d; font-size: 14px;">لا توجد صورة حالية</div>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="image" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                تغيير الصورة
                            </label>
                            <div style="border: 2px dashed #bdc3c7; padding: 20px; text-align: center; background: #f8f9fa; cursor: pointer;"
                                 onclick="document.getElementById('image').click()">
                                <input type="file" class="form-control" id="image" name="image" accept="image/*" 
                                       style="display: none;"
                                       onchange="previewImage(this)">
                                <i class="fas fa-cloud-upload-alt" style="font-size: 24px; color: #7f8c8d; margin-bottom: 10px;"></i>
                                <div style="color: #7f8c8d; font-size: 14px;">انقر لاختيار صورة جديدة</div>
                                <div style="color: #7f8c8d; font-size: 12px; margin-top: 5px;">أو اسحب وأفلت الصورة هنا</div>
                                <div id="fileName" style="color: #3498db; font-size: 12px; margin-top: 10px;"></div>
                            </div>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 8px;">
                                <i class="fas fa-info-circle"></i> اتركه فارغاً للحفاظ على الصورة الحالية - الحد الأقصى: 5MB
                            </small>
                        </div>
                    </div>
                </div>

                <!-- الأسعار والمخزون -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #27ae60; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-dollar-sign" style="margin-left: 8px; color: #27ae60;"></i>
                            الأسعار والمخزون
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="default_price" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> السعر الافتراضي
                            </label>
                            <div style="position: relative;">
                                <input type="number" step="0.01" class="form-control" id="default_price" name="default_price" required 
                                       style="width: 100%; padding: 10px 12px 10px 30px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($item['default_price']); ?>">
                                <span style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d;">¥</span>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="current_stock" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                المخزون الحالي
                            </label>
                            <input type="number" step="0.001" class="form-control" id="current_stock" name="current_stock" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($item['current_stock']); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="unit_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> وحدة القياس
                            </label>
                            <select class="form-control" id="unit_id" name="unit_id" required 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر وحدة القياس</option>
                                <?php foreach ($units as $unit): ?>
                                    <option value="<?php echo $unit['id']; ?>" 
                                            <?php echo ($item['unit_id'] == $unit['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($unit['name'] . ' (' . $unit['code'] . ')'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #e67e22; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-file-alt" style="margin-left: 8px; color: #e67e22;"></i>
                            معلومات إضافية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="company_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الشركة الموردة
                            </label>
                            <select class="form-control" id="company_id" name="company_id"
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر الشركة الموردة (اختياري)</option>
                                <?php foreach ($companies as $company): ?>
                                    <option value="<?php echo $company['id']; ?>" 
                                            <?php echo ($item['company_id'] == $company['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($company['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="specifications" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                المواصفات
                            </label>
                            <textarea class="form-control" id="specifications" name="specifications" rows="4"
                                      style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; resize: vertical;"
                                      placeholder="أدخل مواصفات الصنف هنا..."><?php echo htmlspecialchars($item['specifications']); ?></textarea>
                        </div>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            معلومات إضافية:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">تاريخ الإنشاء</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo date('Y-m-d', strtotime($item['created_at'])); ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">آخر تحديث</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo !empty($item['updated_at']) ? date('Y-m-d', strtotime($item['updated_at'])) : 'لم يتم التحديث'; ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">قيمة المخزون</div>
                            <div style="color: #27ae60; font-weight: 600;">
                                <?php echo number_format($item['default_price'] * $item['current_stock'], 2); ?> 
                                <span style="font-size: 11px; color: #7f8c8d;"><?php echo $defaultCurrencySymbol ?? '¥'; ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="items.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        تحديث البيانات
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%237f8c8d' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 15px;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const priceField = document.getElementById('default_price');
    const unitField = document.getElementById('unit_id');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    priceField.style.borderColor = '#bdc3c7';
    priceField.style.boxShadow = 'none';
    unitField.style.borderColor = '#bdc3c7';
    unitField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate price
    const price = parseFloat(priceField.value);
    if (!priceField.value.trim() || isNaN(price) || price <= 0) {
        priceField.style.borderColor = '#e74c3c';
        priceField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('السعر يجب أن يكون رقماً أكبر من الصفر');
        isValid = false;
    }
    
    // Validate unit
    if (!unitField.value) {
        unitField.style.borderColor = '#e74c3c';
        unitField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

function previewImage(input) {
    const fileName = document.getElementById('fileName');
    const currentImage = document.getElementById('currentImage');
    
    if (input.files && input.files[0]) {
        // Validate file size (max 5MB)
        if (input.files[0].size > 5 * 1024 * 1024) {
            alert('حجم الصورة يجب أن يكون أقل من 5MB');
            input.value = '';
            fileName.textContent = '';
            return;
        }
        
        // Validate file type
        const validTypes = ['image/jpeg', 'image/png', 'image/gif'];
        if (!validTypes.includes(input.files[0].type)) {
            alert('نوع الملف غير مدعوم. الرجاء اختيار صورة من نوع JPG, PNG, أو GIF');
            input.value = '';
            fileName.textContent = '';
            return;
        }
        
        fileName.textContent = input.files[0].name;
        fileName.innerHTML += ' <span style="color:#27ae60;">✓</span>';
        
        // Preview new image
        const reader = new FileReader();
        reader.onload = function(e) {
            if (currentImage) {
                currentImage.src = e.target.result;
            }
        };
        reader.readAsDataURL(input.files[0]);
    } else {
        fileName.textContent = '';
    }
}

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Handle select change
document.getElementById('unit_id').addEventListener('change', function() {
    if (this.value) {
        this.style.borderColor = '#bdc3c7';
        this.style.boxShadow = 'none';
    }
});

// Drag and drop functionality
const dropZone = document.querySelector('div[onclick*="document.getElementById"]');
dropZone.addEventListener('dragover', function(e) {
    e.preventDefault();
    this.style.borderColor = '#3498db';
    this.style.background = '#e8f4fd';
});

dropZone.addEventListener('dragleave', function(e) {
    e.preventDefault();
    this.style.borderColor = '#bdc3c7';
    this.style.background = '#f8f9fa';
});

dropZone.addEventListener('drop', function(e) {
    e.preventDefault();
    this.style.borderColor = '#bdc3c7';
    this.style.background = '#f8f9fa';
    
    const files = e.dataTransfer.files;
    if (files.length > 0) {
        document.getElementById('image').files = files;
        previewImage(document.getElementById('image'));
    }
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>